// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The authentication options for Azure OpenAI On Your Data when using an Elasticsearch encoded API key.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("encoded_api_key")
@Immutable
public final class OnYourDataEncodedApiKeyAuthenticationOptions extends OnYourDataAuthenticationOptions {

    /*
     * The encoded API key to use for authentication.
     */
    @Generated
    @JsonProperty(value = "encoded_api_key")
    private String encodedApiKey;

    /**
     * Creates an instance of OnYourDataEncodedApiKeyAuthenticationOptions class.
     *
     * @param encodedApiKey the encodedApiKey value to set.
     */
    @Generated
    @JsonCreator
    public OnYourDataEncodedApiKeyAuthenticationOptions(@JsonProperty(value = "encoded_api_key") String encodedApiKey) {
        this.encodedApiKey = encodedApiKey;
    }

    /**
     * Get the encodedApiKey property: The encoded API key to use for authentication.
     *
     * @return the encodedApiKey value.
     */
    @Generated
    public String getEncodedApiKey() {
        return this.encodedApiKey;
    }
}
