// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.openai;

import com.azure.core.util.ServiceVersion;

/**
 * Service version of OpenAIClient.
 */
public enum OpenAIServiceVersion implements ServiceVersion {
    /**
     * Enum value 2022-12-01.
     */
    V2022_12_01("2022-12-01"),

    /**
     * Enum value 2023-05-15.
     */
    V2023_05_15("2023-05-15"),

    /**
     * Enum value 2023-06-01-preview.
     */
    V2023_06_01_PREVIEW("2023-06-01-preview"),

    /**
     * Enum value 2023-07-01-preview.
     */
    V2023_07_01_PREVIEW("2023-07-01-preview"),

    /**
     * Enum value 2024-02-15-preview.
     */
    V2024_02_15_PREVIEW("2024-02-15-preview"),

    /**
     * Enum value 2024-03-01-preview.
     */
    V2024_03_01_PREVIEW("2024-03-01-preview"),

    /**
     * Enum value 2024-04-01-preview.
     */
    V2024_04_01_PREVIEW("2024-04-01-preview"),

    /**
     * Enum value 2024-05-01-preview.
     */
    V2024_05_01_PREVIEW("2024-05-01-preview");

    private final String version;

    OpenAIServiceVersion(String version) {
        this.version = version;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getVersion() {
        return this.version;
    }

    /**
     * Gets the latest service version supported by this client library.
     * 
     * @return The latest {@link OpenAIServiceVersion}.
     */
    public static OpenAIServiceVersion getLatest() {
        return V2024_05_01_PREVIEW;
    }
}
