// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.openai.models;

/** The name and arguments of a function that should be called, as generated by the model. */
public class FunctionCallConfig {

    /**
     * The name of the function to call.
     */
    private final String name;

    /**
     * AUTO will indicate the service to call any functions that are necessary for text completion generation.
     */
    public static final FunctionCallConfig AUTO = new FunctionCallConfig("auto");

    /**
     * NONE will indicate the service to not call nay of the functions that may have been provided with the request for
     * text completion generation.
     */
    public static final FunctionCallConfig NONE = new FunctionCallConfig("none");

    /**
     * Creates an instance of FunctionCallConfig class.
     *
     * @param name the name value to set.
     */
    public FunctionCallConfig(String name) {
        this.name = name;
    }

    /**
     * Get the name property: The name of the function to call.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }
}
