// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the request data used to generate images.
 */
@Fluent
public final class ImageGenerationOptions implements JsonSerializable<ImageGenerationOptions> {

    /*
     * A description of the desired images.
     */
    @Generated
    private final String prompt;

    /*
     * The number of images to generate.
     * Dall-e-2 models support values between 1 and 10.
     * Dall-e-3 models only support a value of 1.
     */
    @Generated
    private Integer n;

    /*
     * The desired dimensions for generated images.
     * Dall-e-2 models support 256x256, 512x512, or 1024x1024.
     * Dall-e-3 models support 1024x1024, 1792x1024, or 1024x1792.
     */
    @Generated
    private ImageSize size;

    /*
     * A unique identifier representing your end-user, which can help to monitor and detect abuse.
     */
    @Generated
    private String user;

    /**
     * Creates an instance of ImageGenerationOptions class.
     *
     * @param prompt the prompt value to set.
     */
    @Generated
    public ImageGenerationOptions(String prompt) {
        this.prompt = prompt;
    }

    /**
     * Get the prompt property: A description of the desired images.
     *
     * @return the prompt value.
     */
    @Generated
    public String getPrompt() {
        return this.prompt;
    }

    /**
     * Get the n property: The number of images to generate.
     * Dall-e-2 models support values between 1 and 10.
     * Dall-e-3 models only support a value of 1.
     *
     * @return the n value.
     */
    @Generated
    public Integer getN() {
        return this.n;
    }

    /**
     * Set the n property: The number of images to generate.
     * Dall-e-2 models support values between 1 and 10.
     * Dall-e-3 models only support a value of 1.
     *
     * @param n the n value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setN(Integer n) {
        this.n = n;
        return this;
    }

    /**
     * Get the size property: The desired dimensions for generated images.
     * Dall-e-2 models support 256x256, 512x512, or 1024x1024.
     * Dall-e-3 models support 1024x1024, 1792x1024, or 1024x1792.
     *
     * @return the size value.
     */
    @Generated
    public ImageSize getSize() {
        return this.size;
    }

    /**
     * Set the size property: The desired dimensions for generated images.
     * Dall-e-2 models support 256x256, 512x512, or 1024x1024.
     * Dall-e-3 models support 1024x1024, 1792x1024, or 1024x1792.
     *
     * @param size the size value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setSize(ImageSize size) {
        this.size = size;
        return this;
    }

    /**
     * Get the user property: A unique identifier representing your end-user, which can help to monitor and detect
     * abuse.
     *
     * @return the user value.
     */
    @Generated
    public String getUser() {
        return this.user;
    }

    /**
     * Set the user property: A unique identifier representing your end-user, which can help to monitor and detect
     * abuse.
     *
     * @param user the user value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setUser(String user) {
        this.user = user;
        return this;
    }

    /*
     * The format in which image generation response items should be presented.
     */
    @Generated
    private ImageGenerationResponseFormat responseFormat;

    /**
     * Get the responseFormat property: The format in which image generation response items should be presented.
     *
     * @return the responseFormat value.
     */
    @Generated
    public ImageGenerationResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    /**
     * Set the responseFormat property: The format in which image generation response items should be presented.
     *
     * @param responseFormat the responseFormat value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setResponseFormat(ImageGenerationResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    /*
     * The model name or Azure OpenAI model deployment name to use for image generation. If not specified, dall-e-2 will
     * be
     * inferred as a default.
     */
    @Generated
    private String model;

    /*
     * The desired image generation quality level to use.
     * Only configurable with dall-e-3 models.
     */
    @Generated
    private ImageGenerationQuality quality;

    /*
     * The desired image generation style to use.
     * Only configurable with dall-e-3 models.
     */
    @Generated
    private ImageGenerationStyle style;

    /**
     * Get the model property: The model name or Azure OpenAI model deployment name to use for image generation. If not
     * specified, dall-e-2 will be
     * inferred as a default.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Set the model property: The model name or Azure OpenAI model deployment name to use for image generation. If not
     * specified, dall-e-2 will be
     * inferred as a default.
     *
     * @param model the model value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setModel(String model) {
        this.model = model;
        return this;
    }

    /**
     * Get the quality property: The desired image generation quality level to use.
     * Only configurable with dall-e-3 models.
     *
     * @return the quality value.
     */
    @Generated
    public ImageGenerationQuality getQuality() {
        return this.quality;
    }

    /**
     * Set the quality property: The desired image generation quality level to use.
     * Only configurable with dall-e-3 models.
     *
     * @param quality the quality value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setQuality(ImageGenerationQuality quality) {
        this.quality = quality;
        return this;
    }

    /**
     * Get the style property: The desired image generation style to use.
     * Only configurable with dall-e-3 models.
     *
     * @return the style value.
     */
    @Generated
    public ImageGenerationStyle getStyle() {
        return this.style;
    }

    /**
     * Set the style property: The desired image generation style to use.
     * Only configurable with dall-e-3 models.
     *
     * @param style the style value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setStyle(ImageGenerationStyle style) {
        this.style = style;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("prompt", this.prompt);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeNumberField("n", this.n);
        jsonWriter.writeStringField("size", this.size == null ? null : this.size.toString());
        jsonWriter.writeStringField("response_format",
            this.responseFormat == null ? null : this.responseFormat.toString());
        jsonWriter.writeStringField("quality", this.quality == null ? null : this.quality.toString());
        jsonWriter.writeStringField("style", this.style == null ? null : this.style.toString());
        jsonWriter.writeStringField("user", this.user);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImageGenerationOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImageGenerationOptions if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ImageGenerationOptions.
     */
    @Generated
    public static ImageGenerationOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String prompt = null;
            String model = null;
            Integer n = null;
            ImageSize size = null;
            ImageGenerationResponseFormat responseFormat = null;
            ImageGenerationQuality quality = null;
            ImageGenerationStyle style = null;
            String user = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("prompt".equals(fieldName)) {
                    prompt = reader.getString();
                } else if ("model".equals(fieldName)) {
                    model = reader.getString();
                } else if ("n".equals(fieldName)) {
                    n = reader.getNullable(JsonReader::getInt);
                } else if ("size".equals(fieldName)) {
                    size = ImageSize.fromString(reader.getString());
                } else if ("response_format".equals(fieldName)) {
                    responseFormat = ImageGenerationResponseFormat.fromString(reader.getString());
                } else if ("quality".equals(fieldName)) {
                    quality = ImageGenerationQuality.fromString(reader.getString());
                } else if ("style".equals(fieldName)) {
                    style = ImageGenerationStyle.fromString(reader.getString());
                } else if ("user".equals(fieldName)) {
                    user = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            ImageGenerationOptions deserializedImageGenerationOptions = new ImageGenerationOptions(prompt);
            deserializedImageGenerationOptions.model = model;
            deserializedImageGenerationOptions.n = n;
            deserializedImageGenerationOptions.size = size;
            deserializedImageGenerationOptions.responseFormat = responseFormat;
            deserializedImageGenerationOptions.quality = quality;
            deserializedImageGenerationOptions.style = style;
            deserializedImageGenerationOptions.user = user;
            return deserializedImageGenerationOptions;
        });
    }
}
