/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.ai.openai.implementation.MultipartDataSerializationResult;
import com.azure.ai.openai.implementation.MultipartField;
import com.azure.ai.openai.models.AudioTranscriptionOptions;
import com.azure.ai.openai.models.AudioTranscriptionTimestampGranularity;
import com.azure.ai.openai.models.AudioTranslationOptions;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class MultipartDataHelper {
    private static final ClientLogger LOGGER = new ClientLogger(MultipartDataHelper.class);
    private final String boundary;
    private final String partSeparator;
    private final String endMarker;
    private final Charset encoderCharset = StandardCharsets.UTF_8;
    private static final String CRLF = "\r\n";

    public MultipartDataHelper() {
        this(UUID.randomUUID().toString().substring(0, 16));
    }

    public MultipartDataHelper(String boundary) {
        this.boundary = boundary;
        this.partSeparator = "--" + boundary;
        this.endMarker = this.partSeparator + "--";
    }

    public String getBoundary() {
        return this.boundary;
    }

    public <T> MultipartDataSerializationResult serializeRequest(T requestOptions) {
        if (requestOptions instanceof AudioTranslationOptions) {
            AudioTranslationOptions audioTranslationOptions = (AudioTranslationOptions)requestOptions;
            byte[] file = audioTranslationOptions.getFile();
            List<MultipartField> fields = this.formatAudioTranslationOptions(audioTranslationOptions);
            return this.serializeRequestFields(file, fields, audioTranslationOptions.getFilename());
        }
        if (requestOptions instanceof AudioTranscriptionOptions) {
            AudioTranscriptionOptions audioTranscriptionOptions = (AudioTranscriptionOptions)requestOptions;
            byte[] file = audioTranscriptionOptions.getFile();
            List<MultipartField> fields = this.formatAudioTranscriptionOptions(audioTranscriptionOptions);
            return this.serializeRequestFields(file, fields, audioTranscriptionOptions.getFilename());
        }
        throw (IllegalArgumentException)LOGGER.logThrowableAsError((Throwable)new IllegalArgumentException("Only AudioTranslationOptions and AudioTranscriptionOptions currently supported"));
    }

    private MultipartDataSerializationResult serializeRequestFields(byte[] file, List<MultipartField> fields, String fileName) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String fileFieldPreamble = this.partSeparator + CRLF + "Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"" + CRLF + "Content-Type: application/octet-stream" + CRLF + CRLF;
        try {
            byteArrayOutputStream.write(fileFieldPreamble.getBytes(this.encoderCharset));
            byteArrayOutputStream.write(file);
            for (MultipartField field : fields) {
                byteArrayOutputStream.write(this.serializeField(field));
            }
            byteArrayOutputStream.write((CRLF + this.endMarker).getBytes(this.encoderCharset));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] totalData = byteArrayOutputStream.toByteArray();
        return new MultipartDataSerializationResult(BinaryData.fromBytes((byte[])totalData), totalData.length);
    }

    private List<MultipartField> formatAudioTranslationOptions(AudioTranslationOptions audioTranslationOptions) {
        ArrayList<MultipartField> fields = new ArrayList<MultipartField>();
        if (audioTranslationOptions.getResponseFormat() != null) {
            fields.add(new MultipartField("response_format", audioTranslationOptions.getResponseFormat().toString()));
        }
        if (audioTranslationOptions.getModel() != null) {
            fields.add(new MultipartField("model", audioTranslationOptions.getModel()));
        }
        if (audioTranslationOptions.getPrompt() != null) {
            fields.add(new MultipartField("prompt", audioTranslationOptions.getPrompt()));
        }
        if (audioTranslationOptions.getTemperature() != null) {
            fields.add(new MultipartField("temperature", String.valueOf(audioTranslationOptions.getTemperature())));
        }
        return fields;
    }

    private List<MultipartField> formatAudioTranscriptionOptions(AudioTranscriptionOptions audioTranscriptionOptions) {
        List<AudioTranscriptionTimestampGranularity> timestampGranularities;
        ArrayList<MultipartField> fields = new ArrayList<MultipartField>();
        if (audioTranscriptionOptions.getResponseFormat() != null) {
            fields.add(new MultipartField("response_format", audioTranscriptionOptions.getResponseFormat().toString()));
        }
        if (audioTranscriptionOptions.getModel() != null) {
            fields.add(new MultipartField("model", audioTranscriptionOptions.getModel()));
        }
        if (audioTranscriptionOptions.getPrompt() != null) {
            fields.add(new MultipartField("prompt", audioTranscriptionOptions.getPrompt()));
        }
        if (audioTranscriptionOptions.getTemperature() != null) {
            fields.add(new MultipartField("temperature", String.valueOf(audioTranscriptionOptions.getTemperature())));
        }
        if (audioTranscriptionOptions.getLanguage() != null) {
            fields.add(new MultipartField("language", audioTranscriptionOptions.getLanguage()));
        }
        if ((timestampGranularities = audioTranscriptionOptions.getTimestampGranularities()) != null) {
            for (AudioTranscriptionTimestampGranularity timestampGranularity : timestampGranularities) {
                fields.add(new MultipartField("timestamp_granularities[]", timestampGranularity.toString()));
            }
        }
        return fields;
    }

    private byte[] serializeField(MultipartField field) {
        String serialized = CRLF + this.partSeparator + CRLF + "Content-Disposition: form-data; name=\"" + field.getWireName() + "\"" + CRLF + CRLF + field.getValue();
        return serialized.getBytes(this.encoderCharset);
    }

    public RequestOptions getRequestOptionsForMultipartFormData(RequestOptions requestOptions, MultipartDataSerializationResult result, String multipartBoundary) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions().setHeader(HttpHeaderName.CONTENT_TYPE, "multipart/form-data; boundary=" + multipartBoundary).setHeader(HttpHeaderName.CONTENT_LENGTH, String.valueOf(result.getDataLength()));
        }
        return requestOptions;
    }
}

