/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatRequestToolMessage
extends ChatRequestMessage {
    private final String content;
    private final String toolCallId;
    private ChatRole role = ChatRole.TOOL;

    public ChatRequestToolMessage(String content, String toolCallId) {
        this.content = content;
        this.toolCallId = toolCallId;
    }

    public String getContent() {
        return this.content;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("tool_call_id", this.toolCallId);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestToolMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestToolMessage)jsonReader.readObject(reader -> {
            String content = null;
            String toolCallId = null;
            ChatRole role = ChatRole.TOOL;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("tool_call_id".equals(fieldName)) {
                    toolCallId = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestToolMessage deserializedChatRequestToolMessage = new ChatRequestToolMessage(content, toolCallId);
            deserializedChatRequestToolMessage.role = role;
            return deserializedChatRequestToolMessage;
        });
    }
}

