/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatMessageContentItem;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class ChatRequestUserMessage
extends ChatRequestMessage {
    private final BinaryData content;
    private String name;
    private ChatRole role = ChatRole.USER;

    private ChatRequestUserMessage(BinaryData content) {
        this.content = content;
    }

    public ChatRequestUserMessage(String content) {
        this(BinaryData.fromString((String)content));
    }

    public ChatRequestUserMessage(ChatMessageContentItem[] content) {
        this(BinaryData.fromObject(Arrays.stream(content).map(BinaryData::fromObject).collect(Collectors.toList())));
    }

    public ChatRequestUserMessage(List<ChatMessageContentItem> content) {
        this(BinaryData.fromObject(content.stream().map(BinaryData::fromObject).collect(Collectors.toList())));
    }

    public BinaryData getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public ChatRequestUserMessage setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBinaryField("content", this.content.toBytes());
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestUserMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestUserMessage)jsonReader.readObject(reader -> {
            BinaryData content = null;
            ChatRole role = ChatRole.USER;
            String name = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestUserMessage deserializedChatRequestUserMessage = new ChatRequestUserMessage(content);
            deserializedChatRequestUserMessage.role = role;
            deserializedChatRequestUserMessage.name = name;
            return deserializedChatRequestUserMessage;
        });
    }
}

