/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CompletionsOptions
implements JsonSerializable<CompletionsOptions> {
    private final List<String> prompt;
    private Integer maxTokens;
    private Double temperature;
    private Double topP;
    private Map<String, Integer> logitBias;
    private String user;
    private Integer n;
    private Integer logprobs;
    private Boolean echo;
    private List<String> stop;
    private Double presencePenalty;
    private Double frequencyPenalty;
    private Integer bestOf;
    private Boolean stream;
    private String model;
    private String suffix;

    public CompletionsOptions(List<String> prompt) {
        this.prompt = prompt;
    }

    public List<String> getPrompt() {
        return this.prompt;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public CompletionsOptions setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public CompletionsOptions setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public CompletionsOptions setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public CompletionsOptions setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public CompletionsOptions setUser(String user) {
        this.user = user;
        return this;
    }

    public Integer getN() {
        return this.n;
    }

    public CompletionsOptions setN(Integer n) {
        this.n = n;
        return this;
    }

    public Integer getLogprobs() {
        return this.logprobs;
    }

    public CompletionsOptions setLogprobs(Integer logprobs) {
        this.logprobs = logprobs;
        return this;
    }

    public Boolean isEcho() {
        return this.echo;
    }

    public CompletionsOptions setEcho(Boolean echo) {
        this.echo = echo;
        return this;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public CompletionsOptions setStop(List<String> stop) {
        this.stop = stop;
        return this;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public CompletionsOptions setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public CompletionsOptions setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    public Integer getBestOf() {
        return this.bestOf;
    }

    public CompletionsOptions setBestOf(Integer bestOf) {
        this.bestOf = bestOf;
        return this;
    }

    public Boolean isStream() {
        return this.stream;
    }

    public CompletionsOptions setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public CompletionsOptions setModel(String model) {
        this.model = model;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public CompletionsOptions setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("prompt", this.prompt, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("max_tokens", (Number)this.maxTokens);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        jsonWriter.writeMapField("logit_bias", this.logitBias, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeStringField("user", this.user);
        jsonWriter.writeNumberField("n", (Number)this.n);
        jsonWriter.writeNumberField("logprobs", (Number)this.logprobs);
        jsonWriter.writeStringField("suffix", this.suffix);
        jsonWriter.writeBooleanField("echo", this.echo);
        jsonWriter.writeArrayField("stop", this.stop, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("presence_penalty", (Number)this.presencePenalty);
        jsonWriter.writeNumberField("frequency_penalty", (Number)this.frequencyPenalty);
        jsonWriter.writeNumberField("best_of", (Number)this.bestOf);
        jsonWriter.writeBooleanField("stream", this.stream);
        jsonWriter.writeStringField("model", this.model);
        return jsonWriter.writeEndObject();
    }

    public static CompletionsOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CompletionsOptions)jsonReader.readObject(reader -> {
            List prompt = null;
            Integer maxTokens = null;
            Double temperature = null;
            Double topP = null;
            Map logitBias = null;
            String user = null;
            Integer n = null;
            Integer logprobs = null;
            String suffix = null;
            Boolean echo = null;
            List stop = null;
            Double presencePenalty = null;
            Double frequencyPenalty = null;
            Integer bestOf = null;
            Boolean stream = null;
            String model = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("prompt".equals(fieldName)) {
                    prompt = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("max_tokens".equals(fieldName)) {
                    maxTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("logit_bias".equals(fieldName)) {
                    logitBias = reader.readMap(reader1 -> reader1.getInt());
                    continue;
                }
                if ("user".equals(fieldName)) {
                    user = reader.getString();
                    continue;
                }
                if ("n".equals(fieldName)) {
                    n = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("logprobs".equals(fieldName)) {
                    logprobs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("suffix".equals(fieldName)) {
                    suffix = reader.getString();
                    continue;
                }
                if ("echo".equals(fieldName)) {
                    echo = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("stop".equals(fieldName)) {
                    stop = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("presence_penalty".equals(fieldName)) {
                    presencePenalty = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("frequency_penalty".equals(fieldName)) {
                    frequencyPenalty = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("best_of".equals(fieldName)) {
                    bestOf = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("stream".equals(fieldName)) {
                    stream = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            CompletionsOptions deserializedCompletionsOptions = new CompletionsOptions(prompt);
            deserializedCompletionsOptions.maxTokens = maxTokens;
            deserializedCompletionsOptions.temperature = temperature;
            deserializedCompletionsOptions.topP = topP;
            deserializedCompletionsOptions.logitBias = logitBias;
            deserializedCompletionsOptions.user = user;
            deserializedCompletionsOptions.n = n;
            deserializedCompletionsOptions.logprobs = logprobs;
            deserializedCompletionsOptions.suffix = suffix;
            deserializedCompletionsOptions.echo = echo;
            deserializedCompletionsOptions.stop = stop;
            deserializedCompletionsOptions.presencePenalty = presencePenalty;
            deserializedCompletionsOptions.frequencyPenalty = frequencyPenalty;
            deserializedCompletionsOptions.bestOf = bestOf;
            deserializedCompletionsOptions.stream = stream;
            deserializedCompletionsOptions.model = model;
            return deserializedCompletionsOptions;
        });
    }
}

