/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.implementation.EmbeddingsUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class EmbeddingItem
implements JsonSerializable<EmbeddingItem> {
    private final String embeddingBase64;
    private final int promptIndex;
    private List<Double> embedding;

    public List<Float> getEmbedding() {
        return EmbeddingsUtils.convertBase64ToFloatList(this.embeddingBase64);
    }

    public String getEmbeddingAsString() {
        return this.embeddingBase64;
    }

    public int getPromptIndex() {
        return this.promptIndex;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("embedding", this.embeddingBase64);
        jsonWriter.writeIntField("index", this.promptIndex);
        return jsonWriter.writeEndObject();
    }

    public static EmbeddingItem fromJson(JsonReader jsonReader) throws IOException {
        return (EmbeddingItem)jsonReader.readObject(reader -> {
            String embedding = null;
            int promptIndex = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("embedding".equals(fieldName)) {
                    embedding = reader.getString();
                    continue;
                }
                if ("index".equals(fieldName)) {
                    promptIndex = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new EmbeddingItem(embedding, promptIndex);
        });
    }

    private EmbeddingItem(String embeddingBase64, int promptIndex) {
        this.embeddingBase64 = embeddingBase64;
        this.promptIndex = promptIndex;
    }
}

