/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OnYourDataVectorizationSource;
import com.azure.ai.openai.models.OnYourDataVectorizationSourceType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OnYourDataModelIdVectorizationSource
extends OnYourDataVectorizationSource {
    private final String modelId;
    private OnYourDataVectorizationSourceType type = OnYourDataVectorizationSourceType.MODEL_ID;

    public OnYourDataModelIdVectorizationSource(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    @Override
    public OnYourDataVectorizationSourceType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("model_id", this.modelId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static OnYourDataModelIdVectorizationSource fromJson(JsonReader jsonReader) throws IOException {
        return (OnYourDataModelIdVectorizationSource)jsonReader.readObject(reader -> {
            String modelId = null;
            OnYourDataVectorizationSourceType type = OnYourDataVectorizationSourceType.MODEL_ID;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("model_id".equals(fieldName)) {
                    modelId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = OnYourDataVectorizationSourceType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            OnYourDataModelIdVectorizationSource deserializedOnYourDataModelIdVectorizationSource = new OnYourDataModelIdVectorizationSource(modelId);
            deserializedOnYourDataModelIdVectorizationSource.type = type;
            return deserializedOnYourDataModelIdVectorizationSource;
        });
    }
}

