/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.agents.persistent.PersistentAgentsAsyncClient;
import com.azure.ai.agents.persistent.PersistentAgentsClient;
import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.PersistentAgentsServiceVersion;
import com.azure.ai.projects.ConnectionsAsyncClient;
import com.azure.ai.projects.ConnectionsClient;
import com.azure.ai.projects.DatasetsAsyncClient;
import com.azure.ai.projects.DatasetsClient;
import com.azure.ai.projects.DeploymentsAsyncClient;
import com.azure.ai.projects.DeploymentsClient;
import com.azure.ai.projects.EvaluationsAsyncClient;
import com.azure.ai.projects.EvaluationsClient;
import com.azure.ai.projects.IndexesAsyncClient;
import com.azure.ai.projects.IndexesClient;
import com.azure.ai.projects.InferenceAsyncClient;
import com.azure.ai.projects.InferenceClient;
import com.azure.ai.projects.ProjectsServiceVersion;
import com.azure.ai.projects.RedTeamsAsyncClient;
import com.azure.ai.projects.RedTeamsClient;
import com.azure.ai.projects.TelemetryAsyncClient;
import com.azure.ai.projects.TelemetryClient;
import com.azure.ai.projects.implementation.AIProjectClientImpl;
import com.azure.ai.projects.implementation.InferenceClientImpl;
import com.azure.ai.projects.models.ApiKeyCredentials;
import com.azure.ai.projects.models.BaseCredentials;
import com.azure.ai.projects.models.Connection;
import com.azure.ai.projects.models.ConnectionType;
import com.azure.ai.projects.models.CredentialType;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.openai.azure.AzureOpenAIServiceVersion;
import com.openai.client.okhttp.OpenAIOkHttpClient;
import com.openai.credential.BearerTokenCredential;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

@ServiceClientBuilder(serviceClients={ConnectionsClient.class, EvaluationsClient.class, DatasetsClient.class, IndexesClient.class, DeploymentsClient.class, RedTeamsClient.class, ConnectionsAsyncClient.class, EvaluationsAsyncClient.class, DatasetsAsyncClient.class, IndexesAsyncClient.class, DeploymentsAsyncClient.class, RedTeamsAsyncClient.class})
public final class AIProjectClientBuilder
implements HttpTrait<AIProjectClientBuilder>,
ConfigurationTrait<AIProjectClientBuilder>,
TokenCredentialTrait<AIProjectClientBuilder>,
EndpointTrait<AIProjectClientBuilder> {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String[] DEFAULT_SCOPES = new String[]{"https://ai.azure.com/.default"};
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-ai-projects.properties");
    private final List<HttpPipelinePolicy> pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpPipeline pipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private ClientOptions clientOptions;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private TokenCredential tokenCredential;
    private String endpoint;
    private ProjectsServiceVersion serviceVersion;
    private RetryPolicy retryPolicy;
    private String openAIConnectionName;
    private AzureOpenAIServiceVersion azureOpenAIServiceVersion;
    private static final ClientLogger LOGGER = new ClientLogger(AIProjectClientBuilder.class);

    public AIProjectClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            LOGGER.atInfo().log("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public AIProjectClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public AIProjectClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public AIProjectClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public AIProjectClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public AIProjectClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        Objects.requireNonNull(customPolicy, "'customPolicy' cannot be null.");
        this.pipelinePolicies.add(customPolicy);
        return this;
    }

    public AIProjectClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public AIProjectClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
        return this;
    }

    public AIProjectClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public AIProjectClientBuilder serviceVersion(ProjectsServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public AIProjectClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    private AIProjectClientImpl buildInnerClient() {
        this.validateClient();
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : this.createHttpPipeline();
        ProjectsServiceVersion localServiceVersion = this.serviceVersion != null ? this.serviceVersion : ProjectsServiceVersion.getLatest();
        AIProjectClientImpl client = new AIProjectClientImpl(localPipeline, JacksonAdapter.createDefaultSerializerAdapter(), this.endpoint, localServiceVersion);
        return client;
    }

    private void validateClient() {
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null.");
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        HttpLogOptions localHttpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        ClientOptions localClientOptions = this.clientOptions == null ? new ClientOptions() : this.clientOptions;
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = PROPERTIES.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)localClientOptions, (HttpLogOptions)localHttpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersFromContextPolicy());
        HttpHeaders headers = CoreUtils.createHttpHeadersFromClientOptions((ClientOptions)localClientOptions);
        if (headers != null) {
            policies.add(new AddHeadersPolicy(headers));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).forEach(p -> policies.add(p));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions, (HttpPipelinePolicy)new RetryPolicy()));
        policies.add(new AddDatePolicy());
        if (this.tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, DEFAULT_SCOPES));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).forEach(p -> policies.add(p));
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(localHttpLogOptions));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(localClientOptions).build();
        return httpPipeline;
    }

    private PersistentAgentsClientBuilder createPersistentAgentsDelegateBuilder() {
        PersistentAgentsClientBuilder builder = new PersistentAgentsClientBuilder();
        if (this.pipeline != null) {
            builder.pipeline(this.pipeline);
        }
        if (this.httpClient != null) {
            builder.httpClient(this.httpClient);
        }
        if (this.httpLogOptions != null) {
            builder.httpLogOptions(this.httpLogOptions);
        }
        if (this.clientOptions != null) {
            builder.clientOptions(this.clientOptions);
        }
        if (this.retryOptions != null) {
            builder.retryOptions(this.retryOptions);
        }
        if (this.configuration != null) {
            builder.configuration(this.configuration);
        }
        if (this.tokenCredential != null) {
            builder.credential(this.tokenCredential);
        }
        if (this.endpoint != null) {
            builder.endpoint(this.endpoint);
        }
        if (this.serviceVersion != null) {
            builder.serviceVersion(PersistentAgentsServiceVersion.valueOf((String)this.serviceVersion.getVersion()));
        }
        if (this.retryPolicy != null) {
            builder.retryPolicy(this.retryPolicy);
        }
        for (HttpPipelinePolicy policy : this.pipelinePolicies) {
            builder.addPolicy(policy);
        }
        return builder;
    }

    public AIProjectClientBuilder openAIConnectionName(String openAIConnectionName) {
        this.openAIConnectionName = openAIConnectionName;
        return this;
    }

    public AIProjectClientBuilder openAIServiceVersion(AzureOpenAIServiceVersion azureOpenAIServiceVersion) {
        this.azureOpenAIServiceVersion = azureOpenAIServiceVersion;
        return this;
    }

    private OpenAIOkHttpClient.Builder createOpenAIOkHttpClientDelegateBuilder() {
        OpenAIOkHttpClient.Builder builder = OpenAIOkHttpClient.builder();
        ConnectionsClient connectionsClient = this.buildConnectionsClient();
        if (this.openAIConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("OpenAI connection name is not set."));
        }
        Connection connection = connectionsClient.getConnection(this.openAIConnectionName, true);
        if (connection.getType() != ConnectionType.AZURE_OPEN_AI) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The connection is not of type OPENAI."));
        }
        String azureOpenAIEndpoint = connection.getTarget();
        if (azureOpenAIEndpoint.endsWith("/")) {
            azureOpenAIEndpoint = azureOpenAIEndpoint.substring(0, azureOpenAIEndpoint.length() - 1);
        }
        builder.baseUrl(azureOpenAIEndpoint);
        BaseCredentials credentials = connection.getCredentials();
        if (credentials.getType() == CredentialType.API_KEY && credentials instanceof ApiKeyCredentials) {
            String apiKey = ((ApiKeyCredentials)credentials).getApiKey();
            builder.apiKey(apiKey);
        } else if (credentials.getType() == CredentialType.ENTRA_ID) {
            if (this.tokenCredential == null) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Credential is required for OpenAI connection."));
            }
            builder.credential(BearerTokenCredential.create(AIProjectClientBuilder.getBearerTokenSupplier(this.tokenCredential, "https://cognitiveservices.azure.com/.default")));
        } else {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unsupported credential type for OpenAI connection."));
        }
        if (this.azureOpenAIServiceVersion != null) {
            builder.azureServiceVersion(this.azureOpenAIServiceVersion);
        }
        return builder;
    }

    public ConnectionsAsyncClient buildConnectionsAsyncClient() {
        return new ConnectionsAsyncClient(this.buildInnerClient().getConnections());
    }

    public DatasetsAsyncClient buildDatasetsAsyncClient() {
        return new DatasetsAsyncClient(this.buildInnerClient().getDatasets());
    }

    public IndexesAsyncClient buildIndexesAsyncClient() {
        return new IndexesAsyncClient(this.buildInnerClient().getIndexes());
    }

    public DeploymentsAsyncClient buildDeploymentsAsyncClient() {
        return new DeploymentsAsyncClient(this.buildInnerClient().getDeployments());
    }

    public ConnectionsClient buildConnectionsClient() {
        return new ConnectionsClient(this.buildInnerClient().getConnections());
    }

    public DatasetsClient buildDatasetsClient() {
        return new DatasetsClient(this.buildInnerClient().getDatasets());
    }

    public IndexesClient buildIndexesClient() {
        return new IndexesClient(this.buildInnerClient().getIndexes());
    }

    public DeploymentsClient buildDeploymentsClient() {
        return new DeploymentsClient(this.buildInnerClient().getDeployments());
    }

    public TelemetryClient buildTelemetryClient() {
        ConnectionsClient connectionsClient = this.buildConnectionsClient();
        return new TelemetryClient(connectionsClient);
    }

    public TelemetryAsyncClient buildTelemetryAsyncClient() {
        ConnectionsAsyncClient connectionsAsyncClient = this.buildConnectionsAsyncClient();
        return new TelemetryAsyncClient(connectionsAsyncClient);
    }

    public PersistentAgentsClient buildPersistentAgentsClient() {
        return this.createPersistentAgentsDelegateBuilder().buildClient();
    }

    public PersistentAgentsAsyncClient buildPersistentAgentsAsyncClient() {
        return this.createPersistentAgentsDelegateBuilder().buildAsyncClient();
    }

    public InferenceClient buildInferenceClient() {
        return new InferenceClient(new InferenceClientImpl(this.createOpenAIOkHttpClientDelegateBuilder()));
    }

    public InferenceAsyncClient buildInferenceAsyncClient() {
        return new InferenceAsyncClient(new InferenceClientImpl(this.createOpenAIOkHttpClientDelegateBuilder()));
    }

    private static Supplier<String> getBearerTokenSupplier(TokenCredential credential, String ... scopes) {
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new BearerTokenAuthenticationPolicy(credential, scopes)}).build();
        return () -> {
            HttpRequest req = new HttpRequest(HttpMethod.GET, "https://www.example.com");
            try (HttpResponse res = pipeline.sendSync(req, Context.NONE);){
                String string = res.getRequest().getHeaders().get(HttpHeaderName.AUTHORIZATION).getValue().split(" ")[1];
                return string;
            }
        };
    }

    public EvaluationsAsyncClient buildEvaluationsAsyncClient() {
        return new EvaluationsAsyncClient(this.buildInnerClient().getEvaluations());
    }

    public RedTeamsAsyncClient buildRedTeamsAsyncClient() {
        return new RedTeamsAsyncClient(this.buildInnerClient().getRedTeams());
    }

    public EvaluationsClient buildEvaluationsClient() {
        return new EvaluationsClient(this.buildInnerClient().getEvaluations());
    }

    public RedTeamsClient buildRedTeamsClient() {
        return new RedTeamsClient(this.buildInnerClient().getRedTeams());
    }
}

