/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.implementation.ConnectionsImpl;
import com.azure.ai.projects.models.Connection;
import com.azure.ai.projects.models.ConnectionType;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AIProjectClientBuilder.class, isAsync=true)
public final class ConnectionsAsyncClient {
    private final ConnectionsImpl serviceClient;

    ConnectionsAsyncClient(ConnectionsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Connection> getConnection(String name, boolean includeCredentials) {
        if (includeCredentials) {
            return this.getConnectionWithCredentials(name);
        }
        return this.getConnection(name);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Connection> getConnection(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getConnectionWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Connection)protocolMethodData.toObject(Connection.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Connection> getDefaultConnection(ConnectionType connectionType) {
        return this.getDefaultConnection(connectionType, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Connection> getDefaultConnection(ConnectionType connectionType, boolean includeCredentials) {
        return this.listConnections(connectionType, true).filter(Connection::isDefault).next().flatMap(connection -> {
            if (includeCredentials && connection != null) {
                return this.getConnectionWithCredentials(connection.getName());
            }
            return Mono.just((Object)connection);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> getConnectionWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getConnectionWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> getConnectionWithCredentialsWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getConnectionWithCredentialsWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listConnections(RequestOptions requestOptions) {
        return this.serviceClient.listConnectionsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Connection> getConnectionWithCredentials(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getConnectionWithCredentialsWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Connection)protocolMethodData.toObject(Connection.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Connection> listConnections(ConnectionType connectionType, Boolean defaultConnection) {
        RequestOptions requestOptions = new RequestOptions();
        if (connectionType != null) {
            requestOptions.addQueryParam("connectionType", connectionType.toString(), false);
        }
        if (defaultConnection != null) {
            requestOptions.addQueryParam("defaultConnection", String.valueOf(defaultConnection), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listConnections(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (Connection)protocolMethodData.toObject(Connection.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Connection> listConnections() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listConnections(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (Connection)protocolMethodData.toObject(Connection.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }
}

