/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.implementation.ConnectionsImpl;
import com.azure.ai.projects.models.Connection;
import com.azure.ai.projects.models.ConnectionType;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;

@ServiceClient(builder=AIProjectClientBuilder.class)
public final class ConnectionsClient {
    private final ConnectionsImpl serviceClient;

    ConnectionsClient(ConnectionsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Connection getDefaultConnection(ConnectionType connectionType) {
        return this.getDefaultConnection(connectionType, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Connection getDefaultConnection(ConnectionType connectionType, boolean includeCredentials) {
        PagedIterable<Connection> connections = this.listConnections(connectionType, true);
        for (Connection connection : connections) {
            if (!connection.isDefault()) continue;
            return connection;
        }
        return null;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Connection getConnection(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (Connection)((BinaryData)this.getConnectionWithResponse(name, requestOptions).getValue()).toObject(Connection.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Connection getConnection(String name, boolean includeCredentials) {
        if (includeCredentials) {
            return this.getConnectionWithCredentials(name);
        }
        return this.getConnection(name);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> getConnectionWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getConnectionWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> getConnectionWithCredentialsWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getConnectionWithCredentialsWithResponse(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listConnections(RequestOptions requestOptions) {
        return this.serviceClient.listConnections(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Connection getConnectionWithCredentials(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return (Connection)((BinaryData)this.getConnectionWithCredentialsWithResponse(name, requestOptions).getValue()).toObject(Connection.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Connection> listConnections(ConnectionType connectionType, Boolean defaultConnection) {
        RequestOptions requestOptions = new RequestOptions();
        if (connectionType != null) {
            requestOptions.addQueryParam("connectionType", connectionType.toString(), false);
        }
        if (defaultConnection != null) {
            requestOptions.addQueryParam("defaultConnection", String.valueOf(defaultConnection), false);
        }
        return this.serviceClient.listConnections(requestOptions).mapPage(bodyItemValue -> (Connection)bodyItemValue.toObject(Connection.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Connection> listConnections() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listConnections(requestOptions).mapPage(bodyItemValue -> (Connection)bodyItemValue.toObject(Connection.class));
    }
}

