/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.implementation.DatasetsImpl;
import com.azure.ai.projects.implementation.JsonMergePatchHelper;
import com.azure.ai.projects.models.AssetCredentialResult;
import com.azure.ai.projects.models.DatasetVersion;
import com.azure.ai.projects.models.FileDatasetVersion;
import com.azure.ai.projects.models.FolderDatasetVersion;
import com.azure.ai.projects.models.PendingUploadRequest;
import com.azure.ai.projects.models.PendingUploadResponse;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClientBuilder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AIProjectClientBuilder.class, isAsync=true)
public final class DatasetsAsyncClient {
    private final DatasetsImpl serviceClient;
    private final ClientLogger logger = new ClientLogger(DatasetsAsyncClient.class);

    DatasetsAsyncClient(DatasetsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> pendingUploadWithResponse(String name, String version, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.pendingUploadWithResponseAsync(name, version, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCredentialsWithResponse(String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.getCredentialsWithResponseAsync(name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PendingUploadResponse> pendingUpload(String name, String version, PendingUploadRequest body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.pendingUploadWithResponse(name, version, BinaryData.fromObject((Object)body), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (PendingUploadResponse)protocolMethodData.toObject(PendingUploadResponse.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AssetCredentialResult> getCredentials(String name, String version) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getCredentialsWithResponse(name, version, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AssetCredentialResult)protocolMethodData.toObject(AssetCredentialResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileDatasetVersion> createDatasetWithFile(String name, String version, Path filePath) {
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            return Mono.error((Throwable)new IllegalArgumentException("The provided path is not a file: " + filePath));
        }
        PendingUploadRequest request = new PendingUploadRequest();
        return this.pendingUpload(name, version, request).flatMap(pendingUploadResponse -> {
            String blobUri = pendingUploadResponse.getBlobReference().getBlobUri();
            String sasUri = pendingUploadResponse.getBlobReference().getCredential().getSasUri();
            BlobAsyncClient blobClient = new BlobClientBuilder().endpoint(sasUri).blobName(name).buildAsyncClient();
            return blobClient.upload(BinaryData.fromFile((Path)filePath), true).thenReturn((Object)blobClient.getBlobUrl());
        }).flatMap(blobUrl -> {
            RequestOptions requestOptions = new RequestOptions();
            FileDatasetVersion fileDataset = new FileDatasetVersion().setDataUri((String)blobUrl);
            return this.createOrUpdateDatasetVersionWithResponse(name, version, BinaryData.fromObject((Object)fileDataset), requestOptions).flatMap(FluxUtil::toMono).map(data -> (FileDatasetVersion)data.toObject(FileDatasetVersion.class));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FolderDatasetVersion> createDatasetWithFolder(String name, String version, Path folderPath) {
        if (!Files.isDirectory(folderPath, new LinkOption[0])) {
            return Mono.error((Throwable)new IllegalArgumentException("The provided path is not a folder: " + folderPath));
        }
        PendingUploadRequest request = new PendingUploadRequest();
        return this.pendingUpload(name, version, request).flatMap(pendingUploadResponse -> {
            String blobContainerUri = pendingUploadResponse.getBlobReference().getBlobUri();
            String sasUri = pendingUploadResponse.getBlobReference().getCredential().getSasUri();
            String containerUrl = blobContainerUri.substring(0, blobContainerUri.lastIndexOf(47));
            try {
                List files = Files.walk(folderPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                return Flux.fromIterable(files).flatMap(filePath -> {
                    String relativePath = folderPath.relativize((Path)filePath).toString().replace('\\', '/');
                    BlobAsyncClient blobClient = new BlobClientBuilder().endpoint(sasUri).blobName(relativePath).buildAsyncClient();
                    return blobClient.upload(BinaryData.fromFile((Path)filePath), true);
                }).then(Mono.just((Object)containerUrl));
            }
            catch (Exception e) {
                return Mono.error((Throwable)new RuntimeException("Error walking through folder path", e));
            }
        }).flatMap(containerUrl -> {
            RequestOptions requestOptions = new RequestOptions();
            FolderDatasetVersion folderDataset = new FolderDatasetVersion().setDataUri((String)containerUrl);
            return this.createOrUpdateDatasetVersionWithResponse(name, version, BinaryData.fromObject((Object)folderDataset), requestOptions).flatMap(FluxUtil::toMono).map(data -> (FolderDatasetVersion)data.toObject(FolderDatasetVersion.class));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDatasetVersions(String name, RequestOptions requestOptions) {
        return this.serviceClient.listDatasetVersionsAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listLatestDatasetVersions(RequestOptions requestOptions) {
        return this.serviceClient.listLatestDatasetVersionsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDatasetVersionWithResponse(String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.getDatasetVersionWithResponseAsync(name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDatasetVersionWithResponse(String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.deleteDatasetVersionWithResponseAsync(name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateDatasetVersionWithResponse(String name, String version, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateDatasetVersionWithResponseAsync(name, version, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DatasetVersion> listDatasetVersions(String name) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listDatasetVersions(name, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DatasetVersion)protocolMethodData.toObject(DatasetVersion.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DatasetVersion> listLatestDatasetVersions() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listLatestDatasetVersions(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DatasetVersion)protocolMethodData.toObject(DatasetVersion.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatasetVersion> getDatasetVersion(String name, String version) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getDatasetVersionWithResponse(name, version, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DatasetVersion)protocolMethodData.toObject(DatasetVersion.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDatasetVersion(String name, String version) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteDatasetVersionWithResponse(name, version, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatasetVersion> createOrUpdateDatasetVersion(String name, String version, DatasetVersion body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getDatasetVersionAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getDatasetVersionAccessor().prepareModelForJsonMergePatch(body, false);
        return this.createOrUpdateDatasetVersionWithResponse(name, version, bodyInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DatasetVersion)protocolMethodData.toObject(DatasetVersion.class));
    }
}

