/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.implementation.DeploymentsImpl;
import com.azure.ai.projects.models.Deployment;
import com.azure.ai.projects.models.DeploymentType;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AIProjectClientBuilder.class, isAsync=true)
public final class DeploymentsAsyncClient {
    private final DeploymentsImpl serviceClient;

    DeploymentsAsyncClient(DeploymentsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentWithResponse(String name, RequestOptions requestOptions) {
        return this.serviceClient.getDeploymentWithResponseAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeployments(RequestOptions requestOptions) {
        return this.serviceClient.listDeploymentsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Deployment> getDeployment(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getDeploymentWithResponse(name, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Deployment)protocolMethodData.toObject(Deployment.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Deployment> listDeployments(String modelPublisher, String modelName, DeploymentType deploymentType) {
        RequestOptions requestOptions = new RequestOptions();
        if (modelPublisher != null) {
            requestOptions.addQueryParam("modelPublisher", modelPublisher, false);
        }
        if (modelName != null) {
            requestOptions.addQueryParam("modelName", modelName, false);
        }
        if (deploymentType != null) {
            requestOptions.addQueryParam("deploymentType", deploymentType.toString(), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listDeployments(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (Deployment)protocolMethodData.toObject(Deployment.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Deployment> listDeployments() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listDeployments(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (Deployment)protocolMethodData.toObject(Deployment.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }
}

