/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.implementation.IndexesImpl;
import com.azure.ai.projects.implementation.JsonMergePatchHelper;
import com.azure.ai.projects.models.Index;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AIProjectClientBuilder.class, isAsync=true)
public final class IndexesAsyncClient {
    private final IndexesImpl serviceClient;

    IndexesAsyncClient(IndexesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listIndexVersions(String name, RequestOptions requestOptions) {
        return this.serviceClient.listIndexVersionsAsync(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listLatestIndexVersions(RequestOptions requestOptions) {
        return this.serviceClient.listLatestIndexVersionsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getIndexVersionWithResponse(String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.getIndexVersionWithResponseAsync(name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteIndexVersionWithResponse(String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.deleteIndexVersionWithResponseAsync(name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateIndexVersionWithResponse(String name, String version, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateIndexVersionWithResponseAsync(name, version, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Index> listIndexVersions(String name) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listIndexVersions(name, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (Index)protocolMethodData.toObject(Index.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Index> listLatestIndexVersions() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listLatestIndexVersions(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (Index)protocolMethodData.toObject(Index.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Index> getIndexVersion(String name, String version) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getIndexVersionWithResponse(name, version, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Index)protocolMethodData.toObject(Index.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteIndexVersion(String name, String version) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteIndexVersionWithResponse(name, version, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Index> createOrUpdateIndexVersion(String name, String version, Index body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getIndexAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getIndexAccessor().prepareModelForJsonMergePatch(body, false);
        return this.createOrUpdateIndexVersionWithResponse(name, version, bodyInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (Index)protocolMethodData.toObject(Index.class));
    }
}

