/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.implementation.IndexesImpl;
import com.azure.ai.projects.implementation.JsonMergePatchHelper;
import com.azure.ai.projects.models.Index;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;

@ServiceClient(builder=AIProjectClientBuilder.class)
public final class IndexesClient {
    private final IndexesImpl serviceClient;

    IndexesClient(IndexesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listIndexVersions(String name, RequestOptions requestOptions) {
        return this.serviceClient.listIndexVersions(name, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listLatestIndexVersions(RequestOptions requestOptions) {
        return this.serviceClient.listLatestIndexVersions(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getIndexVersionWithResponse(String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.getIndexVersionWithResponse(name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteIndexVersionWithResponse(String name, String version, RequestOptions requestOptions) {
        return this.serviceClient.deleteIndexVersionWithResponse(name, version, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateIndexVersionWithResponse(String name, String version, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateIndexVersionWithResponse(name, version, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Index> listIndexVersions(String name) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listIndexVersions(name, requestOptions).mapPage(bodyItemValue -> (Index)bodyItemValue.toObject(Index.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<Index> listLatestIndexVersions() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listLatestIndexVersions(requestOptions).mapPage(bodyItemValue -> (Index)bodyItemValue.toObject(Index.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Index getIndexVersion(String name, String version) {
        RequestOptions requestOptions = new RequestOptions();
        return (Index)((BinaryData)this.getIndexVersionWithResponse(name, version, requestOptions).getValue()).toObject(Index.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteIndexVersion(String name, String version) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteIndexVersionWithResponse(name, version, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Index createOrUpdateIndexVersion(String name, String version, Index body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getIndexAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getIndexAccessor().prepareModelForJsonMergePatch(body, false);
        return (Index)((BinaryData)this.createOrUpdateIndexVersionWithResponse(name, version, bodyInBinaryData, requestOptions).getValue()).toObject(Index.class);
    }
}

