/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.ConnectionsAsyncClient;
import com.azure.ai.projects.models.Connection;
import com.azure.ai.projects.models.ConnectionType;
import com.azure.ai.projects.models.CredentialType;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.AzureException;
import com.azure.core.util.logging.ClientLogger;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AIProjectClientBuilder.class, isAsync=true)
public final class TelemetryAsyncClient {
    private final ConnectionsAsyncClient connectionsAsyncClient;
    private final ClientLogger logger = new ClientLogger(TelemetryAsyncClient.class);

    TelemetryAsyncClient(ConnectionsAsyncClient connectionsAsyncClient) {
        this.connectionsAsyncClient = connectionsAsyncClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getConnectionString() {
        return this.connectionsAsyncClient.listConnections(ConnectionType.APPLICATION_INSIGHTS, true).collectList().flatMap(connections -> {
            if (connections.isEmpty()) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new AzureException("No Application Insights connection found.")));
            }
            String connectionName = ((Connection)connections.get(0)).getName();
            return this.connectionsAsyncClient.getConnectionWithCredentials(connectionName).flatMap(connection -> {
                if (connection.getCredentials().getType() != CredentialType.API_KEY) {
                    return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new AzureException("Application Insights connection does not use API Key credentials.")));
                }
                if (connection.getId() == null || connection.getId().isEmpty()) {
                    return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new AzureException("Application Insights connection does not have a connection string.")));
                }
                return Mono.just((Object)connection.getId());
            });
        });
    }
}

