/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects;

import com.azure.ai.projects.AIProjectClientBuilder;
import com.azure.ai.projects.ConnectionsClient;
import com.azure.ai.projects.models.Connection;
import com.azure.ai.projects.models.ConnectionType;
import com.azure.ai.projects.models.CredentialType;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.AzureException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.logging.ClientLogger;
import java.util.Iterator;

@ServiceClient(builder=AIProjectClientBuilder.class)
public final class TelemetryClient {
    private final ConnectionsClient connectionsClient;
    private final ClientLogger logger = new ClientLogger(TelemetryClient.class);
    private static final String ENV_CONTENT_RECORDING_ENABLED = "AZURE_TRACING_GEN_AI_CONTENT_RECORDING_ENABLED";

    TelemetryClient(ConnectionsClient connectionsClient) {
        this.connectionsClient = connectionsClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getConnectionString() {
        PagedIterable<Connection> connections = this.connectionsClient.listConnections(ConnectionType.APPLICATION_INSIGHTS, true);
        Iterator iterator = connections.iterator();
        if (iterator.hasNext()) {
            Connection connection = this.connectionsClient.getConnection(((Connection)iterator.next()).getName(), true);
            if (connection.getCredentials().getType() == CredentialType.API_KEY) {
                if (connection.getId() != null) {
                    return connection.getId();
                }
                throw this.logger.logExceptionAsError((RuntimeException)new AzureException("Application Insights connection does not have a connection string."));
            }
            throw this.logger.logExceptionAsError((RuntimeException)new AzureException("Application Insights connection does not use API Key credentials."));
        }
        throw this.logger.logExceptionAsError((RuntimeException)new AzureException("No Application Insights connection found."));
    }
}

