/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.implementation;

import com.azure.ai.projects.ProjectsServiceVersion;
import com.azure.ai.projects.implementation.ConnectionsImpl;
import com.azure.ai.projects.implementation.DatasetsImpl;
import com.azure.ai.projects.implementation.DeploymentsImpl;
import com.azure.ai.projects.implementation.EvaluationsImpl;
import com.azure.ai.projects.implementation.IndexesImpl;
import com.azure.ai.projects.implementation.RedTeamsImpl;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;

public final class AIProjectClientImpl {
    private final String endpoint;
    private final ProjectsServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final ConnectionsImpl connections;
    private final EvaluationsImpl evaluations;
    private final DatasetsImpl datasets;
    private final IndexesImpl indexes;
    private final DeploymentsImpl deployments;
    private final RedTeamsImpl redTeams;

    public String getEndpoint() {
        return this.endpoint;
    }

    public ProjectsServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public ConnectionsImpl getConnections() {
        return this.connections;
    }

    public EvaluationsImpl getEvaluations() {
        return this.evaluations;
    }

    public DatasetsImpl getDatasets() {
        return this.datasets;
    }

    public IndexesImpl getIndexes() {
        return this.indexes;
    }

    public DeploymentsImpl getDeployments() {
        return this.deployments;
    }

    public RedTeamsImpl getRedTeams() {
        return this.redTeams;
    }

    public AIProjectClientImpl(String endpoint, ProjectsServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public AIProjectClientImpl(HttpPipeline httpPipeline, String endpoint, ProjectsServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public AIProjectClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, ProjectsServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.connections = new ConnectionsImpl(this);
        this.evaluations = new EvaluationsImpl(this);
        this.datasets = new DatasetsImpl(this);
        this.indexes = new IndexesImpl(this);
        this.deployments = new DeploymentsImpl(this);
        this.redTeams = new RedTeamsImpl(this);
    }
}

