/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.implementation;

import com.azure.ai.projects.ProjectsServiceVersion;
import com.azure.ai.projects.implementation.AIProjectClientImpl;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class IndexesImpl {
    private final IndexesService service;
    private final AIProjectClientImpl client;

    IndexesImpl(AIProjectClientImpl client) {
        this.service = (IndexesService)RestProxy.create(IndexesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public ProjectsServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listIndexVersionsSinglePageAsync(String name, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listIndexVersions(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), name, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listIndexVersionsAsync(String name, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listIndexVersionsSinglePageAsync(name, requestOptions), nextLink -> this.listIndexVersionsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listIndexVersionsSinglePage(String name, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listIndexVersionsSync(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), name, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listIndexVersions(String name, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listIndexVersionsSinglePage(name, requestOptions), nextLink -> this.listIndexVersionsNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listLatestIndexVersionsSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listLatestIndexVersions(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listLatestIndexVersionsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listLatestIndexVersionsSinglePageAsync(requestOptions), nextLink -> this.listLatestIndexVersionsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listLatestIndexVersionsSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listLatestIndexVersionsSync(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listLatestIndexVersions(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listLatestIndexVersionsSinglePage(requestOptions), nextLink -> this.listLatestIndexVersionsNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getIndexVersionWithResponseAsync(String name, String version, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getIndexVersion(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), name, version, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getIndexVersionWithResponse(String name, String version, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getIndexVersionSync(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), name, version, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteIndexVersionWithResponseAsync(String name, String version, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteIndexVersion(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), name, version, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteIndexVersionWithResponse(String name, String version, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteIndexVersionSync(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), name, version, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateIndexVersionWithResponseAsync(String name, String version, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/merge-patch+json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateIndexVersion(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), name, "application/merge-patch+json", version, "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateIndexVersionWithResponse(String name, String version, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/merge-patch+json";
        String accept = "application/json";
        return this.service.createOrUpdateIndexVersionSync(this.client.getEndpoint(), this.client.getServiceVersion().getVersion(), name, "application/merge-patch+json", version, "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listIndexVersionsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listIndexVersionsNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listIndexVersionsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listIndexVersionsNextSync(nextLink, this.client.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listLatestIndexVersionsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listLatestIndexVersionsNext(nextLink, this.client.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listLatestIndexVersionsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listLatestIndexVersionsNextSync(nextLink, this.client.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AIProjectClientIndexes")
    public static interface IndexesService {
        @Get(value="/indexes/{name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listIndexVersions(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/indexes/{name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listIndexVersionsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="name") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/indexes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listLatestIndexVersions(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/indexes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listLatestIndexVersionsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/indexes/{name}/versions/{version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getIndexVersion(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="name") String var3, @PathParam(value="version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/indexes/{name}/versions/{version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getIndexVersionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="name") String var3, @PathParam(value="version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Delete(value="/indexes/{name}/versions/{version}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> deleteIndexVersion(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="name") String var3, @PathParam(value="version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Delete(value="/indexes/{name}/versions/{version}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> deleteIndexVersionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="name") String var3, @PathParam(value="version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Patch(value="/indexes/{name}/versions/{version}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createOrUpdateIndexVersion(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="name") String var3, @HeaderParam(value="Content-Type") String var4, @PathParam(value="version") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/merge-patch+json") BinaryData var7, RequestOptions var8, Context var9);

        @Patch(value="/indexes/{name}/versions/{version}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> createOrUpdateIndexVersionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="name") String var3, @HeaderParam(value="Content-Type") String var4, @PathParam(value="version") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/merge-patch+json") BinaryData var7, RequestOptions var8, Context var9);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listIndexVersionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listIndexVersionsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listLatestIndexVersionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listLatestIndexVersionsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);
    }
}

