/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.AgentEvaluationResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AgentEvaluation
implements JsonSerializable<AgentEvaluation> {
    private final String id;
    private final String status;
    private String error;
    private List<AgentEvaluationResult> result;

    private AgentEvaluation(String id, String status) {
        this.id = id;
        this.status = status;
    }

    public String getId() {
        return this.id;
    }

    public String getStatus() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public List<AgentEvaluationResult> getResult() {
        return this.result;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("error", this.error);
        jsonWriter.writeArrayField("result", this.result, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AgentEvaluation fromJson(JsonReader jsonReader) throws IOException {
        return (AgentEvaluation)jsonReader.readObject(reader -> {
            String id = null;
            String status = null;
            String error = null;
            List result = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = reader.getString();
                    continue;
                }
                if ("result".equals(fieldName)) {
                    result = reader.readArray(reader1 -> AgentEvaluationResult.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            AgentEvaluation deserializedAgentEvaluation = new AgentEvaluation(id, status);
            deserializedAgentEvaluation.error = error;
            deserializedAgentEvaluation.result = result;
            return deserializedAgentEvaluation;
        });
    }
}

