/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class AgentEvaluationResult
implements JsonSerializable<AgentEvaluationResult> {
    private final String evaluator;
    private final String evaluatorId;
    private final double score;
    private final String status;
    private String reason;
    private String version;
    private String threadId;
    private final String runId;
    private String error;
    private Map<String, String> additionalDetails;

    private AgentEvaluationResult(String evaluator, String evaluatorId, double score, String status, String runId) {
        this.evaluator = evaluator;
        this.evaluatorId = evaluatorId;
        this.score = score;
        this.status = status;
        this.runId = runId;
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    public String getEvaluatorId() {
        return this.evaluatorId;
    }

    public double getScore() {
        return this.score;
    }

    public String getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public String getVersion() {
        return this.version;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public String getRunId() {
        return this.runId;
    }

    public String getError() {
        return this.error;
    }

    public Map<String, String> getAdditionalDetails() {
        return this.additionalDetails;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("evaluator", this.evaluator);
        jsonWriter.writeStringField("evaluatorId", this.evaluatorId);
        jsonWriter.writeDoubleField("score", this.score);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("runId", this.runId);
        jsonWriter.writeStringField("reason", this.reason);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeStringField("threadId", this.threadId);
        jsonWriter.writeStringField("error", this.error);
        jsonWriter.writeMapField("additionalDetails", this.additionalDetails, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AgentEvaluationResult fromJson(JsonReader jsonReader) throws IOException {
        return (AgentEvaluationResult)jsonReader.readObject(reader -> {
            String evaluator = null;
            String evaluatorId = null;
            double score = 0.0;
            String status = null;
            String runId = null;
            String reason = null;
            String version = null;
            String threadId = null;
            String error = null;
            Map additionalDetails = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("evaluator".equals(fieldName)) {
                    evaluator = reader.getString();
                    continue;
                }
                if ("evaluatorId".equals(fieldName)) {
                    evaluatorId = reader.getString();
                    continue;
                }
                if ("score".equals(fieldName)) {
                    score = reader.getDouble();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = reader.getString();
                    continue;
                }
                if ("runId".equals(fieldName)) {
                    runId = reader.getString();
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    reason = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    version = reader.getString();
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    threadId = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = reader.getString();
                    continue;
                }
                if ("additionalDetails".equals(fieldName)) {
                    additionalDetails = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            AgentEvaluationResult deserializedAgentEvaluationResult = new AgentEvaluationResult(evaluator, evaluatorId, score, status, runId);
            deserializedAgentEvaluationResult.reason = reason;
            deserializedAgentEvaluationResult.version = version;
            deserializedAgentEvaluationResult.threadId = threadId;
            deserializedAgentEvaluationResult.error = error;
            deserializedAgentEvaluationResult.additionalDetails = additionalDetails;
            return deserializedAgentEvaluationResult;
        });
    }
}

