/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AgentEvaluationSamplingConfiguration
implements JsonSerializable<AgentEvaluationSamplingConfiguration> {
    private final String name;
    private final double samplingPercent;
    private final double maxRequestRate;

    public AgentEvaluationSamplingConfiguration(String name, double samplingPercent, double maxRequestRate) {
        this.name = name;
        this.samplingPercent = samplingPercent;
        this.maxRequestRate = maxRequestRate;
    }

    public String getName() {
        return this.name;
    }

    public double getSamplingPercent() {
        return this.samplingPercent;
    }

    public double getMaxRequestRate() {
        return this.maxRequestRate;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeDoubleField("samplingPercent", this.samplingPercent);
        jsonWriter.writeDoubleField("maxRequestRate", this.maxRequestRate);
        return jsonWriter.writeEndObject();
    }

    public static AgentEvaluationSamplingConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (AgentEvaluationSamplingConfiguration)jsonReader.readObject(reader -> {
            String name = null;
            double samplingPercent = 0.0;
            double maxRequestRate = 0.0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("samplingPercent".equals(fieldName)) {
                    samplingPercent = reader.getDouble();
                    continue;
                }
                if ("maxRequestRate".equals(fieldName)) {
                    maxRequestRate = reader.getDouble();
                    continue;
                }
                reader.skipChildren();
            }
            return new AgentEvaluationSamplingConfiguration(name, samplingPercent, maxRequestRate);
        });
    }
}

