/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.BaseCredentials;
import com.azure.ai.projects.models.CredentialType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ApiKeyCredentials
extends BaseCredentials {
    private CredentialType type = CredentialType.API_KEY;
    private String apiKey;

    private ApiKeyCredentials() {
    }

    @Override
    public CredentialType getType() {
        return this.type;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ApiKeyCredentials fromJson(JsonReader jsonReader) throws IOException {
        return (ApiKeyCredentials)jsonReader.readObject(reader -> {
            ApiKeyCredentials deserializedApiKeyCredentials = new ApiKeyCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedApiKeyCredentials.type = CredentialType.fromString(reader.getString());
                    continue;
                }
                if ("key".equals(fieldName)) {
                    deserializedApiKeyCredentials.apiKey = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiKeyCredentials;
        });
    }
}

