/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.TargetConfig;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureOpenAIModelConfiguration
extends TargetConfig {
    private String type = "AzureOpenAIModel";
    private final String modelDeploymentName;

    public AzureOpenAIModelConfiguration(String modelDeploymentName) {
        this.modelDeploymentName = modelDeploymentName;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getModelDeploymentName() {
        return this.modelDeploymentName;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelDeploymentName", this.modelDeploymentName);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static AzureOpenAIModelConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (AzureOpenAIModelConfiguration)jsonReader.readObject(reader -> {
            String modelDeploymentName = null;
            String type = "AzureOpenAIModel";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelDeploymentName".equals(fieldName)) {
                    modelDeploymentName = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            AzureOpenAIModelConfiguration deserializedAzureOpenAIModelConfiguration = new AzureOpenAIModelConfiguration(modelDeploymentName);
            deserializedAzureOpenAIModelConfiguration.type = type;
            return deserializedAzureOpenAIModelConfiguration;
        });
    }
}

