/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.BaseCredentials;
import com.azure.ai.projects.models.ConnectionType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class Connection
implements JsonSerializable<Connection> {
    private String name;
    private String id;
    private ConnectionType type;
    private String target;
    private boolean isDefault;
    private BaseCredentials credentials;
    private Map<String, String> metadata;

    private Connection() {
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public BaseCredentials getCredentials() {
        return this.credentials;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static Connection fromJson(JsonReader jsonReader) throws IOException {
        return (Connection)jsonReader.readObject(reader -> {
            Connection deserializedConnection = new Connection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedConnection.name = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedConnection.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConnection.type = ConnectionType.fromString(reader.getString());
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedConnection.target = reader.getString();
                    continue;
                }
                if ("isDefault".equals(fieldName)) {
                    deserializedConnection.isDefault = reader.getBoolean();
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedConnection.credentials = BaseCredentials.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedConnection.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnection;
        });
    }
}

