/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.implementation.JsonMergePatchHelper;
import com.azure.ai.projects.models.EmbeddingConfiguration;
import com.azure.ai.projects.models.FieldMapping;
import com.azure.ai.projects.models.Index;
import com.azure.ai.projects.models.IndexType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class CosmosDBIndex
extends Index {
    private IndexType type = IndexType.COSMOS_DB;
    private String connectionName;
    private String databaseName;
    private String containerName;
    private EmbeddingConfiguration embeddingConfiguration;
    private FieldMapping fieldMapping;
    private final Set<String> updatedProperties = new HashSet<String>();

    @Override
    public IndexType getType() {
        return this.type;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public CosmosDBIndex setConnectionName(String connectionName) {
        this.connectionName = connectionName;
        this.updatedProperties.add("connectionName");
        return this;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public CosmosDBIndex setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        this.updatedProperties.add("databaseName");
        return this;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public CosmosDBIndex setContainerName(String containerName) {
        this.containerName = containerName;
        this.updatedProperties.add("containerName");
        return this;
    }

    public EmbeddingConfiguration getEmbeddingConfiguration() {
        return this.embeddingConfiguration;
    }

    public CosmosDBIndex setEmbeddingConfiguration(EmbeddingConfiguration embeddingConfiguration) {
        this.embeddingConfiguration = embeddingConfiguration;
        this.updatedProperties.add("embeddingConfiguration");
        return this;
    }

    public FieldMapping getFieldMapping() {
        return this.fieldMapping;
    }

    public CosmosDBIndex setFieldMapping(FieldMapping fieldMapping) {
        this.fieldMapping = fieldMapping;
        this.updatedProperties.add("fieldMapping");
        return this;
    }

    @Override
    public CosmosDBIndex setDescription(String description) {
        super.setDescription(description);
        this.updatedProperties.add("description");
        return this;
    }

    @Override
    public CosmosDBIndex setTags(Map<String, String> tags) {
        super.setTags(tags);
        this.updatedProperties.add("tags");
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (JsonMergePatchHelper.getIndexAccessor().isJsonMergePatch(this)) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("connectionName", this.connectionName);
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("containerName", this.containerName);
        jsonWriter.writeJsonField("embeddingConfiguration", (JsonSerializable)this.embeddingConfiguration);
        jsonWriter.writeJsonField("fieldMapping", (JsonSerializable)this.fieldMapping);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("description")) {
            if (this.getDescription() == null) {
                jsonWriter.writeNullField("description");
            } else {
                jsonWriter.writeStringField("description", this.getDescription());
            }
        }
        if (this.updatedProperties.contains("tags")) {
            if (this.getTags() == null) {
                jsonWriter.writeNullField("tags");
            } else {
                jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> {
                    if (element != null) {
                        writer.writeString(element);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        jsonWriter.writeStringField("type", this.type.toString());
        if (this.updatedProperties.contains("connectionName")) {
            if (this.connectionName == null) {
                jsonWriter.writeNullField("connectionName");
            } else {
                jsonWriter.writeStringField("connectionName", this.connectionName);
            }
        }
        if (this.updatedProperties.contains("databaseName")) {
            if (this.databaseName == null) {
                jsonWriter.writeNullField("databaseName");
            } else {
                jsonWriter.writeStringField("databaseName", this.databaseName);
            }
        }
        if (this.updatedProperties.contains("containerName")) {
            if (this.containerName == null) {
                jsonWriter.writeNullField("containerName");
            } else {
                jsonWriter.writeStringField("containerName", this.containerName);
            }
        }
        if (this.updatedProperties.contains("embeddingConfiguration")) {
            if (this.embeddingConfiguration == null) {
                jsonWriter.writeNullField("embeddingConfiguration");
            } else {
                JsonMergePatchHelper.getEmbeddingConfigurationAccessor().prepareModelForJsonMergePatch(this.embeddingConfiguration, true);
                jsonWriter.writeJsonField("embeddingConfiguration", (JsonSerializable)this.embeddingConfiguration);
                JsonMergePatchHelper.getEmbeddingConfigurationAccessor().prepareModelForJsonMergePatch(this.embeddingConfiguration, false);
            }
        }
        if (this.updatedProperties.contains("fieldMapping")) {
            if (this.fieldMapping == null) {
                jsonWriter.writeNullField("fieldMapping");
            } else {
                JsonMergePatchHelper.getFieldMappingAccessor().prepareModelForJsonMergePatch(this.fieldMapping, true);
                jsonWriter.writeJsonField("fieldMapping", (JsonSerializable)this.fieldMapping);
                JsonMergePatchHelper.getFieldMappingAccessor().prepareModelForJsonMergePatch(this.fieldMapping, false);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CosmosDBIndex fromJson(JsonReader jsonReader) throws IOException {
        return (CosmosDBIndex)jsonReader.readObject(reader -> {
            CosmosDBIndex deserializedCosmosDBIndex = new CosmosDBIndex();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    JsonMergePatchHelper.getIndexAccessor().setName(deserializedCosmosDBIndex, reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    JsonMergePatchHelper.getIndexAccessor().setVersion(deserializedCosmosDBIndex, reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    JsonMergePatchHelper.getIndexAccessor().setId(deserializedCosmosDBIndex, reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    JsonMergePatchHelper.getIndexAccessor().setDescription(deserializedCosmosDBIndex, reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    JsonMergePatchHelper.getIndexAccessor().setTags(deserializedCosmosDBIndex, tags);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCosmosDBIndex.type = IndexType.fromString(reader.getString());
                    continue;
                }
                if ("connectionName".equals(fieldName)) {
                    deserializedCosmosDBIndex.connectionName = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedCosmosDBIndex.databaseName = reader.getString();
                    continue;
                }
                if ("containerName".equals(fieldName)) {
                    deserializedCosmosDBIndex.containerName = reader.getString();
                    continue;
                }
                if ("embeddingConfiguration".equals(fieldName)) {
                    deserializedCosmosDBIndex.embeddingConfiguration = EmbeddingConfiguration.fromJson(reader);
                    continue;
                }
                if ("fieldMapping".equals(fieldName)) {
                    deserializedCosmosDBIndex.fieldMapping = FieldMapping.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCosmosDBIndex;
        });
    }
}

