/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class EvaluatorConfiguration
implements JsonSerializable<EvaluatorConfiguration> {
    private final String id;
    private Map<String, BinaryData> initParams;
    private Map<String, String> dataMapping;

    public EvaluatorConfiguration(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, BinaryData> getInitParams() {
        return this.initParams;
    }

    public EvaluatorConfiguration setInitParams(Map<String, BinaryData> initParams) {
        this.initParams = initParams;
        return this;
    }

    public Map<String, String> getDataMapping() {
        return this.dataMapping;
    }

    public EvaluatorConfiguration setDataMapping(Map<String, String> dataMapping) {
        this.dataMapping = dataMapping;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeMapField("initParams", this.initParams, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeMapField("dataMapping", this.dataMapping, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static EvaluatorConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (EvaluatorConfiguration)jsonReader.readObject(reader -> {
            String id = null;
            Map initParams = null;
            Map dataMapping = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("initParams".equals(fieldName)) {
                    initParams = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("dataMapping".equals(fieldName)) {
                    dataMapping = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            EvaluatorConfiguration deserializedEvaluatorConfiguration = new EvaluatorConfiguration(id);
            deserializedEvaluatorConfiguration.initParams = initParams;
            deserializedEvaluatorConfiguration.dataMapping = dataMapping;
            return deserializedEvaluatorConfiguration;
        });
    }
}

