/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.implementation.JsonMergePatchHelper;
import com.azure.ai.projects.models.DatasetType;
import com.azure.ai.projects.models.DatasetVersion;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class FolderDatasetVersion
extends DatasetVersion {
    private DatasetType type = DatasetType.URI_FOLDER;
    private final Set<String> updatedProperties = new HashSet<String>();

    @Override
    public DatasetType getType() {
        return this.type;
    }

    @Override
    public FolderDatasetVersion setDataUri(String dataUri) {
        super.setDataUri(dataUri);
        this.updatedProperties.add("dataUri");
        return this;
    }

    @Override
    public FolderDatasetVersion setDescription(String description) {
        super.setDescription(description);
        this.updatedProperties.add("description");
        return this;
    }

    @Override
    public FolderDatasetVersion setTags(Map<String, String> tags) {
        super.setTags(tags);
        this.updatedProperties.add("tags");
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (JsonMergePatchHelper.getDatasetVersionAccessor().isJsonMergePatch(this)) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataUri", this.getDataUri());
        jsonWriter.writeStringField("connectionName", this.getConnectionName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("dataUri")) {
            if (this.getDataUri() == null) {
                jsonWriter.writeNullField("dataUri");
            } else {
                jsonWriter.writeStringField("dataUri", this.getDataUri());
            }
        }
        if (this.updatedProperties.contains("connectionName")) {
            if (this.getConnectionName() == null) {
                jsonWriter.writeNullField("connectionName");
            } else {
                jsonWriter.writeStringField("connectionName", this.getConnectionName());
            }
        }
        if (this.updatedProperties.contains("description")) {
            if (this.getDescription() == null) {
                jsonWriter.writeNullField("description");
            } else {
                jsonWriter.writeStringField("description", this.getDescription());
            }
        }
        if (this.updatedProperties.contains("tags")) {
            if (this.getTags() == null) {
                jsonWriter.writeNullField("tags");
            } else {
                jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> {
                    if (element != null) {
                        writer.writeString(element);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        jsonWriter.writeStringField("type", this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static FolderDatasetVersion fromJson(JsonReader jsonReader) throws IOException {
        return (FolderDatasetVersion)jsonReader.readObject(reader -> {
            FolderDatasetVersion deserializedFolderDatasetVersion = new FolderDatasetVersion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    JsonMergePatchHelper.getDatasetVersionAccessor().setName(deserializedFolderDatasetVersion, reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    JsonMergePatchHelper.getDatasetVersionAccessor().setVersion(deserializedFolderDatasetVersion, reader.getString());
                    continue;
                }
                if ("dataUri".equals(fieldName)) {
                    JsonMergePatchHelper.getDatasetVersionAccessor().setDataUri(deserializedFolderDatasetVersion, reader.getString());
                    continue;
                }
                if ("isReference".equals(fieldName)) {
                    JsonMergePatchHelper.getDatasetVersionAccessor().setIsReference(deserializedFolderDatasetVersion, (Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("connectionName".equals(fieldName)) {
                    JsonMergePatchHelper.getDatasetVersionAccessor().setConnectionName(deserializedFolderDatasetVersion, reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    JsonMergePatchHelper.getDatasetVersionAccessor().setId(deserializedFolderDatasetVersion, reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    JsonMergePatchHelper.getDatasetVersionAccessor().setDescription(deserializedFolderDatasetVersion, reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    JsonMergePatchHelper.getDatasetVersionAccessor().setTags(deserializedFolderDatasetVersion, tags);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFolderDatasetVersion.type = DatasetType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFolderDatasetVersion;
        });
    }

    @Override
    public FolderDatasetVersion setConnectionName(String connectionName) {
        super.setConnectionName(connectionName);
        this.updatedProperties.add("connectionName");
        return this;
    }
}

