/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.InputDataset;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class InputData
implements JsonSerializable<InputData> {
    private String type = "InputData";

    public String getType() {
        return this.type;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static InputData fromJson(JsonReader jsonReader) throws IOException {
        return (InputData)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                InputData inputData;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("dataset".equals(discriminatorValue)) {
                    inputData = InputDataset.fromJson(readerToUse.reset());
                    return inputData;
                }
                inputData = InputData.fromJsonKnownDiscriminator(readerToUse.reset());
                return inputData;
            }
        });
    }

    static InputData fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (InputData)jsonReader.readObject(reader -> {
            InputData deserializedInputData = new InputData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedInputData.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInputData;
        });
    }
}

