/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.implementation.JsonMergePatchHelper;
import com.azure.ai.projects.models.Index;
import com.azure.ai.projects.models.IndexType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ManagedAzureAISearchIndex
extends Index {
    private IndexType type = IndexType.MANAGED_AZURE_SEARCH;
    private String vectorStoreId;
    private final Set<String> updatedProperties = new HashSet<String>();

    @Override
    public IndexType getType() {
        return this.type;
    }

    public String getVectorStoreId() {
        return this.vectorStoreId;
    }

    public ManagedAzureAISearchIndex setVectorStoreId(String vectorStoreId) {
        this.vectorStoreId = vectorStoreId;
        this.updatedProperties.add("vectorStoreId");
        return this;
    }

    @Override
    public ManagedAzureAISearchIndex setDescription(String description) {
        super.setDescription(description);
        this.updatedProperties.add("description");
        return this;
    }

    @Override
    public ManagedAzureAISearchIndex setTags(Map<String, String> tags) {
        super.setTags(tags);
        this.updatedProperties.add("tags");
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (JsonMergePatchHelper.getIndexAccessor().isJsonMergePatch(this)) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("vectorStoreId", this.vectorStoreId);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("description")) {
            if (this.getDescription() == null) {
                jsonWriter.writeNullField("description");
            } else {
                jsonWriter.writeStringField("description", this.getDescription());
            }
        }
        if (this.updatedProperties.contains("tags")) {
            if (this.getTags() == null) {
                jsonWriter.writeNullField("tags");
            } else {
                jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> {
                    if (element != null) {
                        writer.writeString(element);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        jsonWriter.writeStringField("type", this.type.toString());
        if (this.updatedProperties.contains("vectorStoreId")) {
            if (this.vectorStoreId == null) {
                jsonWriter.writeNullField("vectorStoreId");
            } else {
                jsonWriter.writeStringField("vectorStoreId", this.vectorStoreId);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ManagedAzureAISearchIndex fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedAzureAISearchIndex)jsonReader.readObject(reader -> {
            ManagedAzureAISearchIndex deserializedManagedAzureAISearchIndex = new ManagedAzureAISearchIndex();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    JsonMergePatchHelper.getIndexAccessor().setName(deserializedManagedAzureAISearchIndex, reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    JsonMergePatchHelper.getIndexAccessor().setVersion(deserializedManagedAzureAISearchIndex, reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    JsonMergePatchHelper.getIndexAccessor().setId(deserializedManagedAzureAISearchIndex, reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    JsonMergePatchHelper.getIndexAccessor().setDescription(deserializedManagedAzureAISearchIndex, reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    JsonMergePatchHelper.getIndexAccessor().setTags(deserializedManagedAzureAISearchIndex, tags);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedAzureAISearchIndex.type = IndexType.fromString(reader.getString());
                    continue;
                }
                if ("vectorStoreId".equals(fieldName)) {
                    deserializedManagedAzureAISearchIndex.vectorStoreId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedAzureAISearchIndex;
        });
    }
}

