/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.BlobReference;
import com.azure.ai.projects.models.PendingUploadType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class PendingUploadResponse
implements JsonSerializable<PendingUploadResponse> {
    private final BlobReference blobReference;
    private final String pendingUploadId;
    private String version;
    private final PendingUploadType pendingUploadType = PendingUploadType.BLOB_REFERENCE;

    private PendingUploadResponse(BlobReference blobReference, String pendingUploadId) {
        this.blobReference = blobReference;
        this.pendingUploadId = pendingUploadId;
    }

    public BlobReference getBlobReference() {
        return this.blobReference;
    }

    public String getPendingUploadId() {
        return this.pendingUploadId;
    }

    public String getVersion() {
        return this.version;
    }

    public PendingUploadType getPendingUploadType() {
        return this.pendingUploadType;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("blobReference", (JsonSerializable)this.blobReference);
        jsonWriter.writeStringField("pendingUploadId", this.pendingUploadId);
        jsonWriter.writeStringField("pendingUploadType", this.pendingUploadType == null ? null : this.pendingUploadType.toString());
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    public static PendingUploadResponse fromJson(JsonReader jsonReader) throws IOException {
        return (PendingUploadResponse)jsonReader.readObject(reader -> {
            BlobReference blobReference = null;
            String pendingUploadId = null;
            String version = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("blobReference".equals(fieldName)) {
                    blobReference = BlobReference.fromJson(reader);
                    continue;
                }
                if ("pendingUploadId".equals(fieldName)) {
                    pendingUploadId = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            PendingUploadResponse deserializedPendingUploadResponse = new PendingUploadResponse(blobReference, pendingUploadId);
            deserializedPendingUploadResponse.version = version;
            return deserializedPendingUploadResponse;
        });
    }
}

