/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.BaseCredentials;
import com.azure.ai.projects.models.CredentialType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SasCredentials
extends BaseCredentials {
    private CredentialType type = CredentialType.SAS;
    private String sasToken;

    @Override
    public CredentialType getType() {
        return this.type;
    }

    public String getSasToken() {
        return this.sasToken;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static SasCredentials fromJson(JsonReader jsonReader) throws IOException {
        return (SasCredentials)jsonReader.readObject(reader -> {
            SasCredentials deserializedSasCredentials = new SasCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedSasCredentials.type = CredentialType.fromString(reader.getString());
                    continue;
                }
                if ("SAS".equals(fieldName)) {
                    deserializedSasCredentials.sasToken = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSasCredentials;
        });
    }

    private SasCredentials() {
    }
}

