/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.projects.models;

import com.azure.ai.projects.models.AzureOpenAIModelConfiguration;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class TargetConfig
implements JsonSerializable<TargetConfig> {
    private String type = "TargetConfig";

    public String getType() {
        return this.type;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static TargetConfig fromJson(JsonReader jsonReader) throws IOException {
        return (TargetConfig)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                TargetConfig targetConfig;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("AzureOpenAIModel".equals(discriminatorValue)) {
                    targetConfig = AzureOpenAIModelConfiguration.fromJson(readerToUse.reset());
                    return targetConfig;
                }
                targetConfig = TargetConfig.fromJsonKnownDiscriminator(readerToUse.reset());
                return targetConfig;
            }
        });
    }

    static TargetConfig fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (TargetConfig)jsonReader.readObject(reader -> {
            TargetConfig deserializedTargetConfig = new TargetConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedTargetConfig.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetConfig;
        });
    }
}

