/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.DocumentSentimentValue;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.SentenceSentimentValue;
import com.azure.ai.textanalytics.implementation.models.SentimentConfidenceScorePerLabel;
import com.azure.ai.textanalytics.implementation.models.SentimentResponse;
import com.azure.ai.textanalytics.implementation.models.WarningCodeValue;
import com.azure.ai.textanalytics.models.AnalyzeSentimentResult;
import com.azure.ai.textanalytics.models.DocumentSentiment;
import com.azure.ai.textanalytics.models.SentenceSentiment;
import com.azure.ai.textanalytics.models.SentimentConfidenceScores;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.models.TextSentiment;
import com.azure.ai.textanalytics.models.WarningCode;
import com.azure.ai.textanalytics.util.AnalyzeSentimentResultCollection;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class AnalyzeSentimentAsyncClient {
    private final ClientLogger logger = new ClientLogger(AnalyzeSentimentAsyncClient.class);
    private final TextAnalyticsClientImpl service;

    AnalyzeSentimentAsyncClient(TextAnalyticsClientImpl service) {
        this.service = service;
    }

    public Mono<Response<AnalyzeSentimentResultCollection>> analyzeSentimentBatch(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        try {
            Utility.inputDocumentsValidation(documents);
            return FluxUtil.withContext(context -> this.getAnalyzedSentimentResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AnalyzeSentimentResultCollection>> analyzeSentimentBatchWithContext(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        try {
            Utility.inputDocumentsValidation(documents);
            return this.getAnalyzedSentimentResponse(documents, options, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Response<AnalyzeSentimentResultCollection> toAnalyzeSentimentResultCollectionResponse(SimpleResponse<SentimentResponse> response) {
        SentimentResponse sentimentResponse = (SentimentResponse)response.getValue();
        ArrayList<AnalyzeSentimentResult> analyzeSentimentResults = new ArrayList<AnalyzeSentimentResult>();
        for (com.azure.ai.textanalytics.implementation.models.DocumentSentiment documentSentiment : sentimentResponse.getDocuments()) {
            analyzeSentimentResults.add(this.convertToAnalyzeSentimentResult(documentSentiment));
        }
        for (DocumentError documentError : sentimentResponse.getErrors()) {
            if (documentError.getId().isEmpty()) {
                throw this.logger.logExceptionAsError((RuntimeException)new HttpResponseException(documentError.getError().getInnererror().getMessage(), Utility.getEmptyErrorIdHttpResponse(response), (Object)documentError.getError().getInnererror().getCode()));
            }
            analyzeSentimentResults.add(new AnalyzeSentimentResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new SimpleResponse(response, (Object)new AnalyzeSentimentResultCollection(analyzeSentimentResults, sentimentResponse.getModelVersion(), sentimentResponse.getStatistics() == null ? null : Utility.toBatchStatistics(sentimentResponse.getStatistics())));
    }

    private AnalyzeSentimentResult convertToAnalyzeSentimentResult(com.azure.ai.textanalytics.implementation.models.DocumentSentiment documentSentiment) {
        SentimentConfidenceScorePerLabel confidenceScorePerLabel = documentSentiment.getConfidenceScores();
        List sentenceSentiments = documentSentiment.getSentences().stream().map(sentenceSentiment -> {
            SentimentConfidenceScorePerLabel confidenceScorePerSentence = sentenceSentiment.getConfidenceScores();
            SentenceSentimentValue sentenceSentimentValue = sentenceSentiment.getSentiment();
            return new SentenceSentiment(sentenceSentiment.getText(), TextSentiment.fromString(sentenceSentimentValue == null ? null : sentenceSentimentValue.toString()), new SentimentConfidenceScores(confidenceScorePerSentence.getNegative(), confidenceScorePerSentence.getNeutral(), confidenceScorePerSentence.getPositive()));
        }).collect(Collectors.toList());
        List warnings = documentSentiment.getWarnings().stream().map(warning -> {
            WarningCodeValue warningCodeValue = warning.getCode();
            return new TextAnalyticsWarning(WarningCode.fromString(warningCodeValue == null ? null : warningCodeValue.toString()), warning.getMessage());
        }).collect(Collectors.toList());
        DocumentSentimentValue documentSentimentValue = documentSentiment.getSentiment();
        return new AnalyzeSentimentResult(documentSentiment.getId(), documentSentiment.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentSentiment.getStatistics()), null, new DocumentSentiment(TextSentiment.fromString(documentSentimentValue == null ? null : documentSentimentValue.toString()), new SentimentConfidenceScores(confidenceScorePerLabel.getNegative(), confidenceScorePerLabel.getNeutral(), confidenceScorePerLabel.getPositive()), (IterableStream<SentenceSentiment>)new IterableStream(sentenceSentiments), (IterableStream<TextAnalyticsWarning>)new IterableStream(warnings)));
    }

    private Mono<Response<AnalyzeSentimentResultCollection>> getAnalyzedSentimentResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        return this.service.sentimentWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), context.addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices"), options == null ? null : options.getModelVersion(), options == null ? null : Boolean.valueOf(options.isIncludeStatistics())).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents - {}", new Object[]{documents.toString()})).doOnSuccess(response -> this.logger.info("Analyzed sentiment for a batch of documents - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to analyze sentiment - {}", new Object[]{error})).map(this::toAnalyzeSentimentResultCollectionResponse).onErrorMap(throwable -> Utility.mapToHttpResponseExceptionIfExist(throwable));
    }
}

