/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.DocumentKeyPhrases;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseResult;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.WarningCodeValue;
import com.azure.ai.textanalytics.models.ExtractKeyPhraseResult;
import com.azure.ai.textanalytics.models.KeyPhrasesCollection;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.models.WarningCode;
import com.azure.ai.textanalytics.util.ExtractKeyPhrasesResultCollection;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class ExtractKeyPhraseAsyncClient {
    private final ClientLogger logger = new ClientLogger(ExtractKeyPhraseAsyncClient.class);
    private final TextAnalyticsClientImpl service;

    ExtractKeyPhraseAsyncClient(TextAnalyticsClientImpl service) {
        this.service = service;
    }

    Mono<KeyPhrasesCollection> extractKeyPhrasesSingleText(String document, String language) {
        try {
            Objects.requireNonNull(document, "'document' cannot be null.");
            TextDocumentInput textDocumentInput = new TextDocumentInput("0", document);
            textDocumentInput.setLanguage(language);
            return this.extractKeyPhrasesWithResponse(Collections.singletonList(textDocumentInput), null).map(resultCollectionResponse -> {
                KeyPhrasesCollection keyPhrasesCollection = null;
                Iterator iterator = ((ExtractKeyPhrasesResultCollection)((Object)((Object)resultCollectionResponse.getValue()))).iterator();
                while (iterator.hasNext()) {
                    ExtractKeyPhraseResult keyPhraseResult = (ExtractKeyPhraseResult)iterator.next();
                    if (keyPhraseResult.isError()) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(keyPhraseResult.getError())));
                    }
                    keyPhrasesCollection = new KeyPhrasesCollection(keyPhraseResult.getKeyPhrases(), keyPhraseResult.getKeyPhrases().getWarnings());
                }
                return keyPhrasesCollection;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ExtractKeyPhrasesResultCollection>> extractKeyPhrasesWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        try {
            Utility.inputDocumentsValidation(documents);
            return FluxUtil.withContext(context -> this.getExtractedKeyPhrasesResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<ExtractKeyPhrasesResultCollection>> extractKeyPhrasesBatchWithContext(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        try {
            Utility.inputDocumentsValidation(documents);
            return this.getExtractedKeyPhrasesResponse(documents, options, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Response<ExtractKeyPhrasesResultCollection> toExtractKeyPhrasesResultCollectionResponse(SimpleResponse<KeyPhraseResult> response) {
        KeyPhraseResult keyPhraseResult = (KeyPhraseResult)response.getValue();
        ArrayList<ExtractKeyPhraseResult> keyPhraseResultList = new ArrayList<ExtractKeyPhraseResult>();
        for (DocumentKeyPhrases documentKeyPhrases : keyPhraseResult.getDocuments()) {
            String documentId = documentKeyPhrases.getId();
            keyPhraseResultList.add(new ExtractKeyPhraseResult(documentId, documentKeyPhrases.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentKeyPhrases.getStatistics()), null, new KeyPhrasesCollection((IterableStream<String>)new IterableStream(documentKeyPhrases.getKeyPhrases()), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentKeyPhrases.getWarnings().stream().map(warning -> {
                WarningCodeValue warningCodeValue = warning.getCode();
                return new TextAnalyticsWarning(WarningCode.fromString(warningCodeValue == null ? null : warningCodeValue.toString()), warning.getMessage());
            }).collect(Collectors.toList())))));
        }
        for (DocumentError documentError : keyPhraseResult.getErrors()) {
            if (documentError.getId().isEmpty()) {
                throw this.logger.logExceptionAsError((RuntimeException)new HttpResponseException(documentError.getError().getInnererror().getMessage(), Utility.getEmptyErrorIdHttpResponse(response), (Object)documentError.getError().getInnererror().getCode()));
            }
            TextAnalyticsError error = Utility.toTextAnalyticsError(documentError.getError());
            String documentId = documentError.getId();
            keyPhraseResultList.add(new ExtractKeyPhraseResult(documentId, null, error, null));
        }
        return new SimpleResponse(response, (Object)new ExtractKeyPhrasesResultCollection(keyPhraseResultList, keyPhraseResult.getModelVersion(), keyPhraseResult.getStatistics() == null ? null : Utility.toBatchStatistics(keyPhraseResult.getStatistics())));
    }

    private Mono<Response<ExtractKeyPhrasesResultCollection>> getExtractedKeyPhrasesResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        return this.service.keyPhrasesWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), context.addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices"), options == null ? null : options.getModelVersion(), options == null ? null : Boolean.valueOf(options.isIncludeStatistics())).doOnSubscribe(ignoredValue -> this.logger.info("A batch of document - {}", new Object[]{documents.toString()})).doOnSuccess(response -> this.logger.info("A batch of key phrases output - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to extract key phrases - {}", new Object[]{error})).map(this::toExtractKeyPhrasesResultCollectionResponse).onErrorMap(throwable -> Utility.mapToHttpResponseExceptionIfExist(throwable));
    }
}

