/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingResult;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.WarningCodeValue;
import com.azure.ai.textanalytics.models.LinkedEntity;
import com.azure.ai.textanalytics.models.LinkedEntityCollection;
import com.azure.ai.textanalytics.models.LinkedEntityMatch;
import com.azure.ai.textanalytics.models.RecognizeLinkedEntitiesResult;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.models.WarningCode;
import com.azure.ai.textanalytics.util.RecognizeLinkedEntitiesResultCollection;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class RecognizeLinkedEntityAsyncClient {
    private final ClientLogger logger = new ClientLogger(RecognizeLinkedEntityAsyncClient.class);
    private final TextAnalyticsClientImpl service;

    RecognizeLinkedEntityAsyncClient(TextAnalyticsClientImpl service) {
        this.service = service;
    }

    Mono<LinkedEntityCollection> recognizeLinkedEntities(String document, String language) {
        try {
            Objects.requireNonNull(document, "'document' cannot be null.");
            TextDocumentInput textDocumentInput = new TextDocumentInput("0", document);
            textDocumentInput.setLanguage(language);
            return this.recognizeLinkedEntitiesBatch(Collections.singletonList(textDocumentInput), null).map(resultCollectionResponse -> {
                LinkedEntityCollection linkedEntityCollection = null;
                Iterator iterator = ((RecognizeLinkedEntitiesResultCollection)((Object)((Object)resultCollectionResponse.getValue()))).iterator();
                while (iterator.hasNext()) {
                    RecognizeLinkedEntitiesResult entitiesResult = (RecognizeLinkedEntitiesResult)iterator.next();
                    if (entitiesResult.isError()) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(entitiesResult.getError())));
                    }
                    linkedEntityCollection = new LinkedEntityCollection(entitiesResult.getEntities(), entitiesResult.getEntities().getWarnings());
                }
                return linkedEntityCollection;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RecognizeLinkedEntitiesResultCollection>> recognizeLinkedEntitiesBatch(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        try {
            Utility.inputDocumentsValidation(documents);
            return FluxUtil.withContext(context -> this.getRecognizedLinkedEntitiesResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RecognizeLinkedEntitiesResultCollection>> recognizeLinkedEntitiesBatchWithContext(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        try {
            Utility.inputDocumentsValidation(documents);
            return this.getRecognizedLinkedEntitiesResponse(documents, options, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Response<RecognizeLinkedEntitiesResultCollection> toRecognizeLinkedEntitiesResultCollectionResponse(SimpleResponse<EntityLinkingResult> response) {
        EntityLinkingResult entityLinkingResult = (EntityLinkingResult)response.getValue();
        ArrayList<RecognizeLinkedEntitiesResult> linkedEntitiesResults = new ArrayList<RecognizeLinkedEntitiesResult>();
        entityLinkingResult.getDocuments().forEach(documentLinkedEntities -> linkedEntitiesResults.add(new RecognizeLinkedEntitiesResult(documentLinkedEntities.getId(), documentLinkedEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentLinkedEntities.getStatistics()), null, new LinkedEntityCollection(this.mapLinkedEntity(documentLinkedEntities.getEntities()), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentLinkedEntities.getWarnings().stream().map(warning -> {
            WarningCodeValue warningCodeValue = warning.getCode();
            return new TextAnalyticsWarning(WarningCode.fromString(warningCodeValue == null ? null : warningCodeValue.toString()), warning.getMessage());
        }).collect(Collectors.toList()))))));
        entityLinkingResult.getErrors().forEach(documentError -> {
            if (documentError.getId().isEmpty()) {
                throw this.logger.logExceptionAsError((RuntimeException)new HttpResponseException(documentError.getError().getInnererror().getMessage(), Utility.getEmptyErrorIdHttpResponse(response), (Object)documentError.getError().getInnererror().getCode()));
            }
            linkedEntitiesResults.add(new RecognizeLinkedEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        });
        return new SimpleResponse(response, (Object)new RecognizeLinkedEntitiesResultCollection(linkedEntitiesResults, entityLinkingResult.getModelVersion(), entityLinkingResult.getStatistics() == null ? null : Utility.toBatchStatistics(entityLinkingResult.getStatistics())));
    }

    private IterableStream<LinkedEntity> mapLinkedEntity(List<com.azure.ai.textanalytics.implementation.models.LinkedEntity> linkedEntities) {
        ArrayList<LinkedEntity> linkedEntitiesList = new ArrayList<LinkedEntity>();
        for (com.azure.ai.textanalytics.implementation.models.LinkedEntity linkedEntity : linkedEntities) {
            linkedEntitiesList.add(new LinkedEntity(linkedEntity.getName(), (IterableStream<LinkedEntityMatch>)new IterableStream((Iterable)linkedEntity.getMatches().stream().map(match -> new LinkedEntityMatch(match.getText(), match.getConfidenceScore())).collect(Collectors.toList())), linkedEntity.getLanguage(), linkedEntity.getId(), linkedEntity.getUrl(), linkedEntity.getDataSource()));
        }
        return new IterableStream(linkedEntitiesList);
    }

    private Mono<Response<RecognizeLinkedEntitiesResultCollection>> getRecognizedLinkedEntitiesResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        return this.service.entitiesLinkingWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), context.addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices"), options == null ? null : options.getModelVersion(), options == null ? null : Boolean.valueOf(options.isIncludeStatistics())).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents - {}", new Object[]{documents.toString()})).doOnSuccess(response -> this.logger.info("Recognized linked entities for a batch of documents - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to recognize linked entities - {}", new Object[]{error})).map(this::toRecognizeLinkedEntitiesResultCollectionResponse).onErrorMap(throwable -> Utility.mapToHttpResponseExceptionIfExist(throwable));
    }
}

