/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsAsyncClient;
import com.azure.ai.textanalytics.TextAnalyticsClientBuilder;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.models.CategorizedEntityCollection;
import com.azure.ai.textanalytics.models.DetectLanguageInput;
import com.azure.ai.textanalytics.models.DetectedLanguage;
import com.azure.ai.textanalytics.models.DocumentSentiment;
import com.azure.ai.textanalytics.models.KeyPhrasesCollection;
import com.azure.ai.textanalytics.models.LinkedEntityCollection;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.AnalyzeSentimentResultCollection;
import com.azure.ai.textanalytics.util.DetectLanguageResultCollection;
import com.azure.ai.textanalytics.util.ExtractKeyPhrasesResultCollection;
import com.azure.ai.textanalytics.util.RecognizeEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizeLinkedEntitiesResultCollection;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import java.util.Objects;

@ServiceClient(builder=TextAnalyticsClientBuilder.class)
public final class TextAnalyticsClient {
    private final TextAnalyticsAsyncClient client;

    TextAnalyticsClient(TextAnalyticsAsyncClient client) {
        this.client = client;
    }

    public String getDefaultCountryHint() {
        return this.client.getDefaultCountryHint();
    }

    public String getDefaultLanguage() {
        return this.client.getDefaultLanguage();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DetectedLanguage detectLanguage(String document) {
        return this.detectLanguage(document, this.client.getDefaultCountryHint());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DetectedLanguage detectLanguage(String document, String countryHint) {
        return (DetectedLanguage)this.client.detectLanguage(document, countryHint).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DetectLanguageResultCollection detectLanguageBatch(Iterable<String> documents, String countryHint, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (DetectLanguageResultCollection)((Object)this.client.detectLanguageBatch(documents, countryHint, options).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DetectLanguageResultCollection> detectLanguageBatchWithResponse(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return (Response)this.client.detectLanguageAsyncClient.detectLanguageBatchWithContext(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CategorizedEntityCollection recognizeEntities(String document) {
        return this.recognizeEntities(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CategorizedEntityCollection recognizeEntities(String document, String language) {
        Objects.requireNonNull(document, "'document' cannot be null.");
        return (CategorizedEntityCollection)((Object)this.client.recognizeEntities(document, language).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecognizeEntitiesResultCollection recognizeEntitiesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (RecognizeEntitiesResultCollection)((Object)this.client.recognizeEntitiesBatch(documents, language, options).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecognizeEntitiesResultCollection> recognizeEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return (Response)this.client.recognizeEntityAsyncClient.recognizeEntitiesBatchWithContext(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedEntityCollection recognizeLinkedEntities(String document) {
        return this.recognizeLinkedEntities(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedEntityCollection recognizeLinkedEntities(String document, String language) {
        Objects.requireNonNull(document, "'document' cannot be null.");
        return (LinkedEntityCollection)((Object)this.client.recognizeLinkedEntities(document, language).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecognizeLinkedEntitiesResultCollection recognizeLinkedEntitiesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (RecognizeLinkedEntitiesResultCollection)((Object)this.client.recognizeLinkedEntitiesBatch(documents, language, options).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecognizeLinkedEntitiesResultCollection> recognizeLinkedEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return (Response)this.client.recognizeLinkedEntityAsyncClient.recognizeLinkedEntitiesBatchWithContext(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyPhrasesCollection extractKeyPhrases(String document) {
        return this.extractKeyPhrases(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyPhrasesCollection extractKeyPhrases(String document, String language) {
        Objects.requireNonNull(document, "'document' cannot be null.");
        return (KeyPhrasesCollection)((Object)this.client.extractKeyPhrases(document, language).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExtractKeyPhrasesResultCollection extractKeyPhrasesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (ExtractKeyPhrasesResultCollection)((Object)this.client.extractKeyPhrasesBatch(documents, language, options).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExtractKeyPhrasesResultCollection> extractKeyPhrasesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return (Response)this.client.extractKeyPhraseAsyncClient.extractKeyPhrasesBatchWithContext(documents, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentSentiment analyzeSentiment(String document) {
        return this.analyzeSentiment(document, this.client.getDefaultLanguage());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DocumentSentiment analyzeSentiment(String document, String language) {
        Objects.requireNonNull(document, "'document' cannot be null.");
        return (DocumentSentiment)this.client.analyzeSentiment(document, language).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnalyzeSentimentResultCollection analyzeSentimentBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        Utility.inputDocumentsValidation(documents);
        return (AnalyzeSentimentResultCollection)((Object)this.client.analyzeSentimentBatch(documents, language, options).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnalyzeSentimentResultCollection> analyzeSentimentBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        Utility.inputDocumentsValidation(documents);
        return (Response)this.client.analyzeSentimentAsyncClient.analyzeSentimentBatchWithContext(documents, options, context).block();
    }
}

