/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsAsyncClient;
import com.azure.ai.textanalytics.TextAnalyticsClient;
import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImplBuilder;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.AzureKeyCredentialPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={TextAnalyticsAsyncClient.class, TextAnalyticsClient.class})
public final class TextAnalyticsClientBuilder {
    private static final String OCP_APIM_SUBSCRIPTION_KEY = "Ocp-Apim-Subscription-Key";
    private static final String ECHO_REQUEST_ID_HEADER = "x-ms-return-client-request-id";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_TYPE_HEADER_VALUE = "application/json";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String TEXT_ANALYTICS_PROPERTIES = "azure-ai-textanalytics.properties";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new RetryPolicy("retry-after-ms", ChronoUnit.MILLIS);
    private static final String DEFAULT_SCOPE = "https://cognitiveservices.azure.com/.default";
    private final ClientLogger logger = new ClientLogger(TextAnalyticsClientBuilder.class);
    private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
    private final HttpHeaders headers;
    private final String clientName;
    private final String clientVersion;
    private String defaultCountryHint;
    private String defaultLanguage;
    private Configuration configuration;
    private AzureKeyCredential credential;
    private String endpoint;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline httpPipeline;
    private RetryPolicy retryPolicy;
    private TokenCredential tokenCredential;
    private TextAnalyticsServiceVersion version;

    public TextAnalyticsClientBuilder() {
        Map properties = CoreUtils.getProperties((String)TEXT_ANALYTICS_PROPERTIES);
        this.clientName = properties.getOrDefault(NAME, "UnknownName");
        this.clientVersion = properties.getOrDefault(VERSION, "UnknownVersion");
        this.headers = new HttpHeaders().put(ECHO_REQUEST_ID_HEADER, "true").put(CONTENT_TYPE_HEADER, CONTENT_TYPE_HEADER_VALUE).put(ACCEPT_HEADER, CONTENT_TYPE_HEADER_VALUE);
    }

    public TextAnalyticsClient buildClient() {
        return new TextAnalyticsClient(this.buildAsyncClient());
    }

    public TextAnalyticsAsyncClient buildAsyncClient() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        TextAnalyticsServiceVersion serviceVersion = this.version != null ? this.version : TextAnalyticsServiceVersion.getLatest();
        Objects.requireNonNull(this.endpoint, "'Endpoint' is required and can not be null.");
        HttpPipeline pipeline = this.httpPipeline;
        if (pipeline == null) {
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(this.httpLogOptions.getApplicationId(), this.clientName, this.clientVersion, buildConfiguration));
            policies.add(new RequestIdPolicy());
            policies.add(new AddHeadersPolicy(this.headers));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy == null ? DEFAULT_RETRY_POLICY : this.retryPolicy);
            policies.add(new AddDatePolicy());
            if (this.tokenCredential != null) {
                policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{DEFAULT_SCOPE}));
            } else if (this.credential != null) {
                policies.add(new AzureKeyCredentialPolicy(OCP_APIM_SUBSCRIPTION_KEY, this.credential));
            } else {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing credential information while building a client."));
            }
            policies.addAll(this.policies);
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            pipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        }
        TextAnalyticsClientImpl textAnalyticsAPI = new TextAnalyticsClientImplBuilder().endpoint(this.endpoint).pipeline(pipeline).build();
        return new TextAnalyticsAsyncClient(textAnalyticsAPI, serviceVersion, this.defaultCountryHint, this.defaultLanguage);
    }

    public TextAnalyticsClientBuilder defaultLanguage(String language) {
        this.defaultLanguage = language;
        return this;
    }

    public TextAnalyticsClientBuilder defaultCountryHint(String countryHint) {
        this.defaultCountryHint = countryHint;
        return this;
    }

    public TextAnalyticsClientBuilder endpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL.", ex));
        }
        this.endpoint = endpoint.endsWith("/") ? endpoint.substring(0, endpoint.length() - 1) : endpoint;
        return this;
    }

    public TextAnalyticsClientBuilder credential(AzureKeyCredential keyCredential) {
        this.credential = Objects.requireNonNull(keyCredential, "'keyCredential' cannot be null.");
        return this;
    }

    public TextAnalyticsClientBuilder credential(TokenCredential tokenCredential) {
        Objects.requireNonNull(tokenCredential, "'tokenCredential' cannot be null.");
        this.tokenCredential = tokenCredential;
        return this;
    }

    public TextAnalyticsClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public TextAnalyticsClientBuilder addPolicy(HttpPipelinePolicy policy) {
        this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
        return this;
    }

    public TextAnalyticsClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            this.logger.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public TextAnalyticsClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public TextAnalyticsClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public TextAnalyticsClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public TextAnalyticsClientBuilder serviceVersion(TextAnalyticsServiceVersion version) {
        this.version = version;
        return this;
    }
}

