/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation;

import com.azure.ai.textanalytics.implementation.models.EntitiesResult;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingResult;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseResult;
import com.azure.ai.textanalytics.implementation.models.LanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.LanguageResult;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.SentimentResponse;
import com.azure.ai.textanalytics.implementation.models.TextAnalyticsErrorException;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import reactor.core.publisher.Mono;

public final class TextAnalyticsClientImpl {
    private final TextAnalyticsClientService service;
    private String endpoint;
    private final HttpPipeline httpPipeline;

    public String getEndpoint() {
        return this.endpoint;
    }

    public TextAnalyticsClientImpl setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public TextAnalyticsClientImpl() {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build());
    }

    public TextAnalyticsClientImpl(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        this.service = (TextAnalyticsClientService)RestProxy.create(TextAnalyticsClientService.class, (HttpPipeline)this.httpPipeline);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SimpleResponse<EntitiesResult>> entitiesRecognitionGeneralWithResponseAsync(MultiLanguageBatchInput input, String modelVersion, Boolean showStats) {
        return FluxUtil.withContext(context -> this.service.entitiesRecognitionGeneral(this.getEndpoint(), modelVersion, showStats, input, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SimpleResponse<EntitiesResult>> entitiesRecognitionGeneralWithResponseAsync(MultiLanguageBatchInput input, Context context, String modelVersion, Boolean showStats) {
        return this.service.entitiesRecognitionGeneral(this.getEndpoint(), modelVersion, showStats, input, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SimpleResponse<EntityLinkingResult>> entitiesLinkingWithResponseAsync(MultiLanguageBatchInput input, String modelVersion, Boolean showStats) {
        return FluxUtil.withContext(context -> this.service.entitiesLinking(this.getEndpoint(), modelVersion, showStats, input, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SimpleResponse<EntityLinkingResult>> entitiesLinkingWithResponseAsync(MultiLanguageBatchInput input, Context context, String modelVersion, Boolean showStats) {
        return this.service.entitiesLinking(this.getEndpoint(), modelVersion, showStats, input, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SimpleResponse<KeyPhraseResult>> keyPhrasesWithResponseAsync(MultiLanguageBatchInput input, String modelVersion, Boolean showStats) {
        return FluxUtil.withContext(context -> this.service.keyPhrases(this.getEndpoint(), modelVersion, showStats, input, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SimpleResponse<KeyPhraseResult>> keyPhrasesWithResponseAsync(MultiLanguageBatchInput input, Context context, String modelVersion, Boolean showStats) {
        return this.service.keyPhrases(this.getEndpoint(), modelVersion, showStats, input, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SimpleResponse<LanguageResult>> languagesWithResponseAsync(LanguageBatchInput input, String modelVersion, Boolean showStats) {
        return FluxUtil.withContext(context -> this.service.languages(this.getEndpoint(), modelVersion, showStats, input, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SimpleResponse<LanguageResult>> languagesWithResponseAsync(LanguageBatchInput input, Context context, String modelVersion, Boolean showStats) {
        return this.service.languages(this.getEndpoint(), modelVersion, showStats, input, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SimpleResponse<SentimentResponse>> sentimentWithResponseAsync(MultiLanguageBatchInput input, String modelVersion, Boolean showStats) {
        return FluxUtil.withContext(context -> this.service.sentiment(this.getEndpoint(), modelVersion, showStats, input, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SimpleResponse<SentimentResponse>> sentimentWithResponseAsync(MultiLanguageBatchInput input, Context context, String modelVersion, Boolean showStats) {
        return this.service.sentiment(this.getEndpoint(), modelVersion, showStats, input, context);
    }

    @Host(value="{Endpoint}/text/analytics/v3.0")
    @ServiceInterface(name="TextAnalyticsClient")
    private static interface TextAnalyticsClientService {
        @Post(value="/entities/recognition/general")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TextAnalyticsErrorException.class)
        public Mono<SimpleResponse<EntitiesResult>> entitiesRecognitionGeneral(@HostParam(value="Endpoint") String var1, @QueryParam(value="model-version") String var2, @QueryParam(value="showStats") Boolean var3, @BodyParam(value="application/json") MultiLanguageBatchInput var4, Context var5);

        @Post(value="/entities/linking")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TextAnalyticsErrorException.class)
        public Mono<SimpleResponse<EntityLinkingResult>> entitiesLinking(@HostParam(value="Endpoint") String var1, @QueryParam(value="model-version") String var2, @QueryParam(value="showStats") Boolean var3, @BodyParam(value="application/json") MultiLanguageBatchInput var4, Context var5);

        @Post(value="/keyPhrases")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TextAnalyticsErrorException.class)
        public Mono<SimpleResponse<KeyPhraseResult>> keyPhrases(@HostParam(value="Endpoint") String var1, @QueryParam(value="model-version") String var2, @QueryParam(value="showStats") Boolean var3, @BodyParam(value="application/json") MultiLanguageBatchInput var4, Context var5);

        @Post(value="/languages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TextAnalyticsErrorException.class)
        public Mono<SimpleResponse<LanguageResult>> languages(@HostParam(value="Endpoint") String var1, @QueryParam(value="model-version") String var2, @QueryParam(value="showStats") Boolean var3, @BodyParam(value="application/json") LanguageBatchInput var4, Context var5);

        @Post(value="/sentiment")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TextAnalyticsErrorException.class)
        public Mono<SimpleResponse<SentimentResponse>> sentiment(@HostParam(value="Endpoint") String var1, @QueryParam(value="model-version") String var2, @QueryParam(value="showStats") Boolean var3, @BodyParam(value="application/json") MultiLanguageBatchInput var4, Context var5);
    }
}

