/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation;

import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;

@ServiceClientBuilder(serviceClients={TextAnalyticsClientImpl.class})
public final class TextAnalyticsClientImplBuilder {
    private String endpoint;
    private HttpPipeline pipeline;

    public TextAnalyticsClientImplBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public TextAnalyticsClientImplBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public TextAnalyticsClientImpl build() {
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        TextAnalyticsClientImpl client = new TextAnalyticsClientImpl(this.pipeline);
        if (this.endpoint != null) {
            client.setEndpoint(this.endpoint);
        }
        return client;
    }
}

