/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation;

import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.ErrorCodeValue;
import com.azure.ai.textanalytics.implementation.models.InnerError;
import com.azure.ai.textanalytics.implementation.models.InnerErrorCodeValue;
import com.azure.ai.textanalytics.implementation.models.LanguageInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageInput;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.TextAnalyticsError;
import com.azure.ai.textanalytics.implementation.models.TextAnalyticsErrorException;
import com.azure.ai.textanalytics.models.DetectLanguageInput;
import com.azure.ai.textanalytics.models.TextAnalyticsErrorCode;
import com.azure.ai.textanalytics.models.TextAnalyticsException;
import com.azure.ai.textanalytics.models.TextDocumentBatchStatistics;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.models.TextDocumentStatistics;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.SimpleResponse;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class Utility {
    private Utility() {
    }

    public static void inputDocumentsValidation(Iterable<?> documents) {
        Objects.requireNonNull(documents, "'documents' cannot be null.");
        Iterator<?> iterator = documents.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("'documents' cannot be empty.");
        }
    }

    public static HttpResponse getEmptyErrorIdHttpResponse(SimpleResponse<?> response) {
        return new HttpResponse(response.getRequest()){

            public int getStatusCode() {
                return 400;
            }

            public String getHeaderValue(String s) {
                return null;
            }

            public HttpHeaders getHeaders() {
                return null;
            }

            public Flux<ByteBuffer> getBody() {
                return null;
            }

            public Mono<byte[]> getBodyAsByteArray() {
                return null;
            }

            public Mono<String> getBodyAsString() {
                return null;
            }

            public Mono<String> getBodyAsString(Charset charset) {
                return null;
            }
        };
    }

    public static Throwable mapToHttpResponseExceptionIfExist(Throwable throwable) {
        if (throwable instanceof TextAnalyticsErrorException) {
            TextAnalyticsErrorException errorException = (TextAnalyticsErrorException)((Object)throwable);
            return new HttpResponseException(errorException.getMessage(), errorException.getResponse(), (Object)Utility.toTextAnalyticsError(errorException.getValue()));
        }
        return throwable;
    }

    public static <T> List<T> mapByIndex(Iterable<String> documents, BiFunction<String, String, T> mappingFunction) {
        Objects.requireNonNull(documents, "'documents' cannot be null.");
        AtomicInteger i = new AtomicInteger(0);
        ArrayList result = new ArrayList();
        documents.forEach(document -> result.add(mappingFunction.apply(String.valueOf(i.getAndIncrement()), (String)document)));
        return result;
    }

    public static TextDocumentStatistics toTextDocumentStatistics(DocumentStatistics statistics) {
        return new TextDocumentStatistics(statistics.getCharactersCount(), statistics.getTransactionsCount());
    }

    public static TextDocumentBatchStatistics toBatchStatistics(RequestStatistics statistics) {
        return new TextDocumentBatchStatistics(statistics.getDocumentsCount(), statistics.getValidDocumentsCount(), statistics.getErroneousDocumentsCount(), statistics.getTransactionsCount());
    }

    public static com.azure.ai.textanalytics.models.TextAnalyticsError toTextAnalyticsError(TextAnalyticsError textAnalyticsError) {
        InnerError innerError = textAnalyticsError.getInnererror();
        if (innerError == null) {
            ErrorCodeValue errorCodeValue = textAnalyticsError.getCode();
            return new com.azure.ai.textanalytics.models.TextAnalyticsError(TextAnalyticsErrorCode.fromString(errorCodeValue == null ? null : errorCodeValue.toString()), textAnalyticsError.getMessage(), textAnalyticsError.getTarget());
        }
        InnerErrorCodeValue innerErrorCodeValue = innerError.getCode();
        return new com.azure.ai.textanalytics.models.TextAnalyticsError(TextAnalyticsErrorCode.fromString(innerErrorCodeValue == null ? null : innerErrorCodeValue.toString()), innerError.getMessage(), innerError.getTarget());
    }

    public static List<MultiLanguageInput> toMultiLanguageInput(Iterable<TextDocumentInput> documents) {
        ArrayList<MultiLanguageInput> multiLanguageInputs = new ArrayList<MultiLanguageInput>();
        for (TextDocumentInput textDocumentInput : documents) {
            multiLanguageInputs.add(new MultiLanguageInput().setId(textDocumentInput.getId()).setText(textDocumentInput.getText()).setLanguage(textDocumentInput.getLanguage()));
        }
        return multiLanguageInputs;
    }

    public static TextAnalyticsException toTextAnalyticsException(com.azure.ai.textanalytics.models.TextAnalyticsError error) {
        return new TextAnalyticsException(error.getMessage(), error.getErrorCode(), error.getTarget());
    }

    public static List<LanguageInput> toLanguageInput(Iterable<DetectLanguageInput> documents) {
        ArrayList<LanguageInput> multiLanguageInputs = new ArrayList<LanguageInput>();
        documents.forEach(textDocumentInput -> multiLanguageInputs.add(new LanguageInput().setId(textDocumentInput.getId()).setText(textDocumentInput.getText()).setCountryHint(textDocumentInput.getCountryHint())));
        return multiLanguageInputs;
    }
}

