/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.models;

import com.azure.ai.textanalytics.models.TextAnalyticsErrorCode;
import com.azure.core.exception.AzureException;

public class TextAnalyticsException
extends AzureException {
    private static final String ERROR_CODE = "ErrorCodeValue";
    private static final String TARGET = "target";
    private final TextAnalyticsErrorCode errorCode;
    private final String target;

    public TextAnalyticsException(String message, TextAnalyticsErrorCode errorCode, String target) {
        super(message);
        this.errorCode = errorCode;
        this.target = target;
    }

    public String getMessage() {
        StringBuilder baseMessage = new StringBuilder().append(super.getMessage()).append(" ").append(ERROR_CODE).append(": {").append(this.errorCode).append("}");
        if (this.target == null) {
            return baseMessage.toString();
        }
        return baseMessage.append(", ").append(TARGET).append(": {").append(this.target).append("}").toString();
    }

    public String getTarget() {
        return this.target;
    }

    public TextAnalyticsErrorCode getErrorCode() {
        return this.errorCode;
    }
}

