/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.implementation.AnalyzeActionsOperationDetailPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AnalyzeActionsResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AnalyzeSentimentActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.ExtractKeyPhrasesActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.RecognizeEntitiesActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.RecognizeLinkedEntitiesActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.RecognizePiiEntitiesActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TextAnalyticsActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeBatchInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeHeaders;
import com.azure.ai.textanalytics.implementation.models.AnalyzeJobState;
import com.azure.ai.textanalytics.implementation.models.EntitiesResult;
import com.azure.ai.textanalytics.implementation.models.EntitiesTask;
import com.azure.ai.textanalytics.implementation.models.EntitiesTaskParameters;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingResult;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingTask;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingTaskParameters;
import com.azure.ai.textanalytics.implementation.models.JobManifestTasks;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseResult;
import com.azure.ai.textanalytics.implementation.models.KeyPhrasesTask;
import com.azure.ai.textanalytics.implementation.models.KeyPhrasesTaskParameters;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.PiiResult;
import com.azure.ai.textanalytics.implementation.models.PiiTask;
import com.azure.ai.textanalytics.implementation.models.PiiTaskParameters;
import com.azure.ai.textanalytics.implementation.models.PiiTaskParametersDomain;
import com.azure.ai.textanalytics.implementation.models.SentimentAnalysisTask;
import com.azure.ai.textanalytics.implementation.models.SentimentAnalysisTaskParameters;
import com.azure.ai.textanalytics.implementation.models.SentimentResponse;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.implementation.models.TaskState;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasks;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasksEntityLinkingTasksItem;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasksEntityRecognitionPiiTasksItem;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasksEntityRecognitionTasksItem;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasksKeyPhraseExtractionTasksItem;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasksSentimentAnalysisTasksItem;
import com.azure.ai.textanalytics.implementation.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.AnalyzeActionsOperationDetail;
import com.azure.ai.textanalytics.models.AnalyzeActionsOptions;
import com.azure.ai.textanalytics.models.AnalyzeActionsResult;
import com.azure.ai.textanalytics.models.AnalyzeSentimentActionResult;
import com.azure.ai.textanalytics.models.ExtractKeyPhrasesActionResult;
import com.azure.ai.textanalytics.models.RecognizeEntitiesActionResult;
import com.azure.ai.textanalytics.models.RecognizeLinkedEntitiesActionResult;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesActionResult;
import com.azure.ai.textanalytics.models.TextAnalyticsActionResult;
import com.azure.ai.textanalytics.models.TextAnalyticsActions;
import com.azure.ai.textanalytics.models.TextAnalyticsErrorCode;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.AnalyzeActionsResultPagedFlux;
import com.azure.ai.textanalytics.util.AnalyzeActionsResultPagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import reactor.core.publisher.Mono;

class AnalyzeActionsAsyncClient {
    private static final String ENTITY_RECOGNITION_TASKS = "entityRecognitionTasks";
    private static final String ENTITY_RECOGNITION_PII_TASKS = "entityRecognitionPiiTasks";
    private static final String KEY_PHRASE_EXTRACTION_TASKS = "keyPhraseExtractionTasks";
    private static final String ENTITY_LINKING_TASKS = "entityLinkingTasks";
    private static final String SENTIMENT_ANALYSIS_TASKS = "sentimentAnalysisTasks";
    private static final String REGEX_ACTION_ERROR_TARGET = "#/tasks/(keyPhraseExtractionTasks|entityRecognitionPiiTasks|entityRecognitionTasks|entityLinkingTasks|sentimentAnalysisTasks)/(\\d+)";
    private final ClientLogger logger = new ClientLogger(AnalyzeActionsAsyncClient.class);
    private final TextAnalyticsClientImpl service;
    private static final Pattern PATTERN = Pattern.compile("#/tasks/(keyPhraseExtractionTasks|entityRecognitionPiiTasks|entityRecognitionTasks|entityLinkingTasks|sentimentAnalysisTasks)/(\\d+)", 8);

    AnalyzeActionsAsyncClient(TextAnalyticsClientImpl service) {
        this.service = service;
    }

    PollerFlux<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedFlux> beginAnalyzeActions(Iterable<TextDocumentInput> documents, TextAnalyticsActions actions, AnalyzeActionsOptions options, Context context) {
        try {
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullAnalyzeActionsOptions(options);
            Context finalContext = this.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices");
            AnalyzeBatchInput analyzeBatchInput = new AnalyzeBatchInput().setAnalysisInput(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(this.getJobManifestTasks(actions));
            analyzeBatchInput.setDisplayName(actions.getDisplayName());
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AnalyzeActionsOperationDetail>)this.service.analyzeWithResponseAsync(analyzeBatchInput, finalContext).map(analyzeResponse -> {
                AnalyzeActionsOperationDetail textAnalyticsOperationResult = new AnalyzeActionsOperationDetail();
                AnalyzeActionsOperationDetailPropertiesHelper.setOperationId(textAnalyticsOperationResult, Utility.parseOperationId(((AnalyzeHeaders)analyzeResponse.getDeserializedHeaders()).getOperationLocation()));
                return textAnalyticsOperationResult;
            })), this.pollingOperation(operationId -> this.service.analyzeStatusWithResponseAsync((String)operationId, finalIncludeStatistics, null, null, finalContext)), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported.")), this.fetchingOperation(operationId -> Mono.just((Object)((Object)this.getAnalyzeOperationFluxPage((String)operationId, null, null, finalIncludeStatistics, finalContext)))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    PollerFlux<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedIterable> beginAnalyzeActionsIterable(Iterable<TextDocumentInput> documents, TextAnalyticsActions actions, AnalyzeActionsOptions options, Context context) {
        try {
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullAnalyzeActionsOptions(options);
            Context finalContext = this.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices");
            AnalyzeBatchInput analyzeBatchInput = new AnalyzeBatchInput().setAnalysisInput(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(this.getJobManifestTasks(actions));
            analyzeBatchInput.setDisplayName(actions.getDisplayName());
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AnalyzeActionsOperationDetail>)this.service.analyzeWithResponseAsync(analyzeBatchInput, finalContext).map(analyzeResponse -> {
                AnalyzeActionsOperationDetail operationDetail = new AnalyzeActionsOperationDetail();
                AnalyzeActionsOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeHeaders)analyzeResponse.getDeserializedHeaders()).getOperationLocation()));
                return operationDetail;
            })), this.pollingOperation(operationId -> this.service.analyzeStatusWithResponseAsync((String)operationId, finalIncludeStatistics, null, null, finalContext)), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported.")), this.fetchingOperationIterable(operationId -> Mono.just((Object)((Object)new AnalyzeActionsResultPagedIterable(this.getAnalyzeOperationFluxPage((String)operationId, null, null, finalIncludeStatistics, finalContext))))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    private JobManifestTasks getJobManifestTasks(TextAnalyticsActions actions) {
        return new JobManifestTasks().setEntityRecognitionTasks(actions.getRecognizeEntitiesActions() == null ? null : StreamSupport.stream(actions.getRecognizeEntitiesActions().spliterator(), false).map(action -> {
            if (action == null) {
                return null;
            }
            EntitiesTask entitiesTask = new EntitiesTask();
            entitiesTask.setParameters(new EntitiesTaskParameters().setModelVersion(action.getModelVersion()).setStringIndexType(StringIndexType.UTF16CODE_UNIT));
            return entitiesTask;
        }).collect(Collectors.toList())).setEntityRecognitionPiiTasks(actions.getRecognizePiiEntitiesActions() == null ? null : StreamSupport.stream(actions.getRecognizePiiEntitiesActions().spliterator(), false).map(action -> {
            if (action == null) {
                return null;
            }
            PiiTask piiTask = new PiiTask();
            piiTask.setParameters(new PiiTaskParameters().setModelVersion(action.getModelVersion()).setDomain(PiiTaskParametersDomain.fromString(action.getDomainFilter() == null ? null : action.getDomainFilter().toString())).setStringIndexType(StringIndexType.UTF16CODE_UNIT).setPiiCategories(Utility.toCategoriesFilter(action.getCategoriesFilter())));
            return piiTask;
        }).collect(Collectors.toList())).setKeyPhraseExtractionTasks(actions.getExtractKeyPhrasesActions() == null ? null : StreamSupport.stream(actions.getExtractKeyPhrasesActions().spliterator(), false).map(action -> {
            if (action == null) {
                return null;
            }
            KeyPhrasesTask keyPhrasesTask = new KeyPhrasesTask();
            keyPhrasesTask.setParameters(new KeyPhrasesTaskParameters().setModelVersion(action.getModelVersion()));
            return keyPhrasesTask;
        }).collect(Collectors.toList())).setEntityLinkingTasks(actions.getRecognizeLinkedEntitiesActions() == null ? null : StreamSupport.stream(actions.getRecognizeLinkedEntitiesActions().spliterator(), false).map(action -> {
            if (action == null) {
                return null;
            }
            EntityLinkingTask entityLinkingTask = new EntityLinkingTask();
            entityLinkingTask.setParameters(new EntityLinkingTaskParameters().setModelVersion(action.getModelVersion()));
            return entityLinkingTask;
        }).collect(Collectors.toList())).setSentimentAnalysisTasks(actions.getAnalyzeSentimentActions() == null ? null : StreamSupport.stream(actions.getAnalyzeSentimentActions().spliterator(), false).map(action -> {
            if (action == null) {
                return null;
            }
            SentimentAnalysisTask sentimentAnalysisTask = new SentimentAnalysisTask();
            sentimentAnalysisTask.setParameters(new SentimentAnalysisTaskParameters().setModelVersion(action.getModelVersion()));
            return sentimentAnalysisTask;
        }).collect(Collectors.toList()));
    }

    private Function<PollingContext<AnalyzeActionsOperationDetail>, Mono<AnalyzeActionsOperationDetail>> activationOperation(Mono<AnalyzeActionsOperationDetail> operationResult) {
        return pollingContext -> {
            try {
                return operationResult.onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeActionsOperationDetail>, Mono<PollResponse<AnalyzeActionsOperationDetail>>> pollingOperation(Function<String, Mono<Response<AnalyzeJobState>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                String operationId = ((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue()).getOperationId();
                return ((Mono)pollingFunction.apply(operationId)).flatMap(modelResponse -> this.processAnalyzedModelResponse((Response<AnalyzeJobState>)modelResponse, (PollResponse<AnalyzeActionsOperationDetail>)operationResultPollResponse)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeActionsOperationDetail>, Mono<AnalyzeActionsResultPagedFlux>> fetchingOperation(Function<String, Mono<AnalyzeActionsResultPagedFlux>> fetchingFunction) {
        return pollingContext -> {
            try {
                String operationId = ((AnalyzeActionsOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId();
                return (Mono)fetchingFunction.apply(operationId);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeActionsOperationDetail>, Mono<AnalyzeActionsResultPagedIterable>> fetchingOperationIterable(Function<String, Mono<AnalyzeActionsResultPagedIterable>> fetchingFunction) {
        return pollingContext -> {
            try {
                String operationId = ((AnalyzeActionsOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId();
                return (Mono)fetchingFunction.apply(operationId);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    AnalyzeActionsResultPagedFlux getAnalyzeOperationFluxPage(String operationId, Integer top, Integer skip, boolean showStats, Context context) {
        return new AnalyzeActionsResultPagedFlux(() -> (continuationToken, pageSize) -> this.getPage((String)continuationToken, operationId, top, skip, showStats, context).flux());
    }

    Mono<PagedResponse<AnalyzeActionsResult>> getPage(String continuationToken, String operationId, Integer top, Integer skip, boolean showStats, Context context) {
        if (continuationToken != null) {
            Map<String, Object> continuationTokenMap = Utility.parseNextLink(continuationToken);
            Integer topValue = continuationTokenMap.getOrDefault("$top", null);
            Integer skipValue = continuationTokenMap.getOrDefault("$skip", null);
            Boolean showStatsValue = (Boolean)continuationTokenMap.getOrDefault(showStats, false);
            return this.service.analyzeStatusWithResponseAsync(operationId, showStatsValue, topValue, skipValue, context).map(this::toAnalyzeActionsResultPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        return this.service.analyzeStatusWithResponseAsync(operationId, showStats, top, skip, context).map(this::toAnalyzeActionsResultPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }

    private PagedResponse<AnalyzeActionsResult> toAnalyzeActionsResultPagedResponse(Response<AnalyzeJobState> response) {
        AnalyzeJobState analyzeJobState = (AnalyzeJobState)response.getValue();
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Arrays.asList(this.toAnalyzeActionsResult(analyzeJobState)), analyzeJobState.getNextLink(), null);
    }

    private AnalyzeActionsResult toAnalyzeActionsResult(AnalyzeJobState analyzeJobState) {
        List<TextAnalyticsError> errors;
        Object results;
        TextAnalyticsActionResult actionResult;
        Object taskItem;
        int i;
        TasksStateTasks tasksStateTasks = analyzeJobState.getTasks();
        List<TasksStateTasksEntityRecognitionPiiTasksItem> piiTasksItems = tasksStateTasks.getEntityRecognitionPiiTasks();
        List<TasksStateTasksEntityRecognitionTasksItem> entityRecognitionTasksItems = tasksStateTasks.getEntityRecognitionTasks();
        List<TasksStateTasksKeyPhraseExtractionTasksItem> keyPhraseExtractionTasks = tasksStateTasks.getKeyPhraseExtractionTasks();
        List<TasksStateTasksEntityLinkingTasksItem> linkedEntityRecognitionTasksItems = tasksStateTasks.getEntityLinkingTasks();
        List<TasksStateTasksSentimentAnalysisTasksItem> sentimentAnalysisTasksItems = tasksStateTasks.getSentimentAnalysisTasks();
        ArrayList<RecognizeEntitiesActionResult> recognizeEntitiesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> recognizePiiEntitiesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> extractKeyPhrasesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> recognizeLinkedEntitiesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> analyzeSentimentActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        if (!CoreUtils.isNullOrEmpty(entityRecognitionTasksItems)) {
            for (i = 0; i < entityRecognitionTasksItems.size(); ++i) {
                taskItem = entityRecognitionTasksItems.get(i);
                actionResult = new RecognizeEntitiesActionResult();
                results = ((TasksStateTasksEntityRecognitionTasksItem)taskItem).getResults();
                if (results != null) {
                    RecognizeEntitiesActionResultPropertiesHelper.setDocumentsResults(actionResult, Utility.toRecognizeEntitiesResultCollectionResponse((EntitiesResult)results));
                }
                TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, ((TaskState)taskItem).getLastUpdateDateTime());
                recognizeEntitiesActionResults.add((RecognizeEntitiesActionResult)actionResult);
            }
        }
        if (!CoreUtils.isNullOrEmpty(piiTasksItems)) {
            for (i = 0; i < piiTasksItems.size(); ++i) {
                taskItem = piiTasksItems.get(i);
                actionResult = new RecognizePiiEntitiesActionResult();
                results = ((TasksStateTasksEntityRecognitionPiiTasksItem)taskItem).getResults();
                if (results != null) {
                    RecognizePiiEntitiesActionResultPropertiesHelper.setDocumentsResults((RecognizePiiEntitiesActionResult)actionResult, Utility.toRecognizePiiEntitiesResultCollection((PiiResult)results));
                }
                TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, ((TaskState)taskItem).getLastUpdateDateTime());
                recognizePiiEntitiesActionResults.add((RecognizeEntitiesActionResult)actionResult);
            }
        }
        if (!CoreUtils.isNullOrEmpty(keyPhraseExtractionTasks)) {
            for (i = 0; i < keyPhraseExtractionTasks.size(); ++i) {
                taskItem = keyPhraseExtractionTasks.get(i);
                actionResult = new ExtractKeyPhrasesActionResult();
                results = ((TasksStateTasksKeyPhraseExtractionTasksItem)taskItem).getResults();
                if (results != null) {
                    ExtractKeyPhrasesActionResultPropertiesHelper.setDocumentsResults((ExtractKeyPhrasesActionResult)actionResult, Utility.toExtractKeyPhrasesResultCollection((KeyPhraseResult)results));
                }
                TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, ((TaskState)taskItem).getLastUpdateDateTime());
                extractKeyPhrasesActionResults.add((RecognizeEntitiesActionResult)actionResult);
            }
        }
        if (!CoreUtils.isNullOrEmpty(linkedEntityRecognitionTasksItems)) {
            for (i = 0; i < linkedEntityRecognitionTasksItems.size(); ++i) {
                taskItem = linkedEntityRecognitionTasksItems.get(i);
                actionResult = new RecognizeLinkedEntitiesActionResult();
                results = ((TasksStateTasksEntityLinkingTasksItem)taskItem).getResults();
                if (results != null) {
                    RecognizeLinkedEntitiesActionResultPropertiesHelper.setDocumentsResults((RecognizeLinkedEntitiesActionResult)actionResult, Utility.toRecognizeLinkedEntitiesResultCollection((EntityLinkingResult)results));
                }
                TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, ((TaskState)taskItem).getLastUpdateDateTime());
                recognizeLinkedEntitiesActionResults.add((RecognizeEntitiesActionResult)actionResult);
            }
        }
        if (!CoreUtils.isNullOrEmpty(sentimentAnalysisTasksItems)) {
            for (i = 0; i < sentimentAnalysisTasksItems.size(); ++i) {
                taskItem = sentimentAnalysisTasksItems.get(i);
                actionResult = new AnalyzeSentimentActionResult();
                results = ((TasksStateTasksSentimentAnalysisTasksItem)taskItem).getResults();
                if (results != null) {
                    AnalyzeSentimentActionResultPropertiesHelper.setDocumentsResults((AnalyzeSentimentActionResult)actionResult, Utility.toAnalyzeSentimentResultCollection((SentimentResponse)results));
                }
                TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, ((TaskState)taskItem).getLastUpdateDateTime());
                analyzeSentimentActionResults.add((RecognizeEntitiesActionResult)actionResult);
            }
        }
        if (!CoreUtils.isNullOrEmpty(errors = analyzeJobState.getErrors())) {
            for (TextAnalyticsError error : errors) {
                TextAnalyticsActionResult actionResult2;
                String[] targetPair = this.parseActionErrorTarget(error.getTarget());
                String taskName = targetPair[0];
                Integer taskIndex = Integer.valueOf(targetPair[1]);
                if (ENTITY_RECOGNITION_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)recognizeEntitiesActionResults.get(taskIndex);
                } else if (ENTITY_RECOGNITION_PII_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)recognizePiiEntitiesActionResults.get(taskIndex);
                } else if (KEY_PHRASE_EXTRACTION_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)extractKeyPhrasesActionResults.get(taskIndex);
                } else if (ENTITY_LINKING_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)recognizeLinkedEntitiesActionResults.get(taskIndex);
                } else if (SENTIMENT_ANALYSIS_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)analyzeSentimentActionResults.get(taskIndex);
                } else {
                    throw this.logger.logExceptionAsError(new RuntimeException("Invalid task name in target reference, " + taskName));
                }
                TextAnalyticsActionResultPropertiesHelper.setIsError(actionResult2, true);
                TextAnalyticsActionResultPropertiesHelper.setError(actionResult2, new com.azure.ai.textanalytics.models.TextAnalyticsError(TextAnalyticsErrorCode.fromString(error.getCode() == null ? null : error.getCode().toString()), error.getMessage(), null));
            }
        }
        AnalyzeActionsResult analyzeActionsResult = new AnalyzeActionsResult();
        AnalyzeActionsResultPropertiesHelper.setRecognizeEntitiesResults(analyzeActionsResult, (IterableStream<RecognizeEntitiesActionResult>)IterableStream.of(recognizeEntitiesActionResults));
        AnalyzeActionsResultPropertiesHelper.setRecognizePiiEntitiesResults(analyzeActionsResult, (IterableStream<RecognizePiiEntitiesActionResult>)IterableStream.of(recognizePiiEntitiesActionResults));
        AnalyzeActionsResultPropertiesHelper.setExtractKeyPhrasesResults(analyzeActionsResult, (IterableStream<ExtractKeyPhrasesActionResult>)IterableStream.of(extractKeyPhrasesActionResults));
        AnalyzeActionsResultPropertiesHelper.setRecognizeLinkedEntitiesResults(analyzeActionsResult, (IterableStream<RecognizeLinkedEntitiesActionResult>)IterableStream.of(recognizeLinkedEntitiesActionResults));
        AnalyzeActionsResultPropertiesHelper.setAnalyzeSentimentResults(analyzeActionsResult, (IterableStream<AnalyzeSentimentActionResult>)IterableStream.of(analyzeSentimentActionResults));
        return analyzeActionsResult;
    }

    private Mono<PollResponse<AnalyzeActionsOperationDetail>> processAnalyzedModelResponse(Response<AnalyzeJobState> analyzeJobStateResponse, PollResponse<AnalyzeActionsOperationDetail> operationResultPollResponse) {
        LongRunningOperationStatus status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
        if (analyzeJobStateResponse.getValue() != null && ((AnalyzeJobState)analyzeJobStateResponse.getValue()).getStatus() != null) {
            switch (((AnalyzeJobState)analyzeJobStateResponse.getValue()).getStatus()) {
                case NOT_STARTED: 
                case RUNNING: {
                    status = LongRunningOperationStatus.IN_PROGRESS;
                    break;
                }
                case SUCCEEDED: {
                    status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                    break;
                }
                case CANCELLED: {
                    status = LongRunningOperationStatus.USER_CANCELLED;
                    break;
                }
                default: {
                    status = LongRunningOperationStatus.fromString((String)((AnalyzeJobState)analyzeJobStateResponse.getValue()).getStatus().toString(), (boolean)true);
                }
            }
        }
        AnalyzeActionsOperationDetailPropertiesHelper.setDisplayName((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeJobState)analyzeJobStateResponse.getValue()).getDisplayName());
        AnalyzeActionsOperationDetailPropertiesHelper.setCreatedAt((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeJobState)analyzeJobStateResponse.getValue()).getCreatedDateTime());
        AnalyzeActionsOperationDetailPropertiesHelper.setExpiresAt((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeJobState)analyzeJobStateResponse.getValue()).getExpirationDateTime());
        AnalyzeActionsOperationDetailPropertiesHelper.setLastModifiedAt((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeJobState)analyzeJobStateResponse.getValue()).getLastUpdateDateTime());
        TasksStateTasks tasksResult = ((AnalyzeJobState)analyzeJobStateResponse.getValue()).getTasks();
        AnalyzeActionsOperationDetailPropertiesHelper.setActionsFailed((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), tasksResult.getFailed());
        AnalyzeActionsOperationDetailPropertiesHelper.setActionsInProgress((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), tasksResult.getInProgress());
        AnalyzeActionsOperationDetailPropertiesHelper.setActionsSucceeded((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), tasksResult.getCompleted());
        AnalyzeActionsOperationDetailPropertiesHelper.setActionsInTotal((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), tasksResult.getTotal());
        return Mono.just((Object)new PollResponse(status, (Object)((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue())));
    }

    private Context getNotNullContext(Context context) {
        return context == null ? Context.NONE : context;
    }

    private AnalyzeActionsOptions getNotNullAnalyzeActionsOptions(AnalyzeActionsOptions options) {
        return options == null ? new AnalyzeActionsOptions() : options;
    }

    private String[] parseActionErrorTarget(String targetReference) {
        if (CoreUtils.isNullOrEmpty((CharSequence)targetReference)) {
            throw this.logger.logExceptionAsError(new RuntimeException("Expected an error with a target field referencing an action but did not get one"));
        }
        Matcher matcher = PATTERN.matcher(targetReference);
        String[] taskNameIdPair = new String[2];
        while (matcher.find()) {
            taskNameIdPair[0] = matcher.group(1);
            taskNameIdPair[1] = matcher.group(2);
        }
        return taskNameIdPair;
    }
}

