/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.DocumentLanguage;
import com.azure.ai.textanalytics.implementation.models.LanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.LanguageResult;
import com.azure.ai.textanalytics.implementation.models.WarningCodeValue;
import com.azure.ai.textanalytics.models.DetectLanguageInput;
import com.azure.ai.textanalytics.models.DetectLanguageResult;
import com.azure.ai.textanalytics.models.DetectedLanguage;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.WarningCode;
import com.azure.ai.textanalytics.util.DetectLanguageResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class DetectLanguageAsyncClient {
    private final ClientLogger logger = new ClientLogger(DetectLanguageAsyncClient.class);
    private final TextAnalyticsClientImpl service;

    DetectLanguageAsyncClient(TextAnalyticsClientImpl service) {
        this.service = service;
    }

    Mono<Response<DetectLanguageResultCollection>> detectLanguageBatch(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options) {
        try {
            Utility.inputDocumentsValidation(documents);
            return FluxUtil.withContext(context -> this.getDetectedLanguageResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<DetectLanguageResultCollection>> detectLanguageBatchWithContext(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options, Context context) {
        try {
            Utility.inputDocumentsValidation(documents);
            return this.getDetectedLanguageResponse(documents, options, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Response<DetectLanguageResultCollection> toTextAnalyticsResultDocumentResponse(Response<LanguageResult> response) {
        LanguageResult languageResult = (LanguageResult)response.getValue();
        ArrayList<DetectLanguageResult> detectLanguageResults = new ArrayList<DetectLanguageResult>();
        for (DocumentLanguage documentLanguage : languageResult.getDocuments()) {
            com.azure.ai.textanalytics.implementation.models.DetectedLanguage detectedLanguage = documentLanguage.getDetectedLanguage();
            List warnings = documentLanguage.getWarnings().stream().map(warning -> {
                WarningCodeValue warningCodeValue = warning.getCode();
                return new TextAnalyticsWarning(WarningCode.fromString(warningCodeValue == null ? null : warningCodeValue.toString()), warning.getMessage());
            }).collect(Collectors.toList());
            detectLanguageResults.add(new DetectLanguageResult(documentLanguage.getId(), documentLanguage.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentLanguage.getStatistics()), null, new DetectedLanguage(detectedLanguage.getName(), detectedLanguage.getIso6391Name(), detectedLanguage.getConfidenceScore(), (IterableStream<TextAnalyticsWarning>)new IterableStream(warnings))));
        }
        for (DocumentError documentError : languageResult.getErrors()) {
            detectLanguageResults.add(new DetectLanguageResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new SimpleResponse(response, (Object)new DetectLanguageResultCollection(detectLanguageResults, languageResult.getModelVersion(), languageResult.getStatistics() == null ? null : Utility.toBatchStatistics(languageResult.getStatistics())));
    }

    private Mono<Response<DetectLanguageResultCollection>> getDetectedLanguageResponse(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options, Context context) {
        options = options == null ? new TextAnalyticsRequestOptions() : options;
        return this.service.languagesWithResponseAsync(new LanguageBatchInput().setDocuments(Utility.toLanguageInput(documents)), options.getModelVersion(), options.isIncludeStatistics(), options.isServiceLogsDisabled(), context.addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices")).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> this.logger.info("Detected languages for a batch of documents - {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to detect language - {}", new Object[]{error})).map(this::toTextAnalyticsResultDocumentResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }
}

