/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.implementation.CategorizedEntityPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.DocumentError;
import com.azure.ai.textanalytics.implementation.models.EntitiesResult;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.implementation.models.WarningCodeValue;
import com.azure.ai.textanalytics.models.CategorizedEntity;
import com.azure.ai.textanalytics.models.CategorizedEntityCollection;
import com.azure.ai.textanalytics.models.EntityCategory;
import com.azure.ai.textanalytics.models.RecognizeEntitiesResult;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsWarning;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.models.WarningCode;
import com.azure.ai.textanalytics.util.RecognizeEntitiesResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class RecognizeEntityAsyncClient {
    private final ClientLogger logger = new ClientLogger(RecognizeEntityAsyncClient.class);
    private final TextAnalyticsClientImpl service;

    RecognizeEntityAsyncClient(TextAnalyticsClientImpl service) {
        this.service = service;
    }

    Mono<CategorizedEntityCollection> recognizeEntities(String document, String language) {
        try {
            Objects.requireNonNull(document, "'document' cannot be null.");
            TextDocumentInput textDocumentInput = new TextDocumentInput("0", document);
            textDocumentInput.setLanguage(language);
            return this.recognizeEntitiesBatch(Collections.singletonList(textDocumentInput), null).map(resultCollectionResponse -> {
                CategorizedEntityCollection entityCollection = null;
                Iterator iterator = ((RecognizeEntitiesResultCollection)((Object)((Object)resultCollectionResponse.getValue()))).iterator();
                while (iterator.hasNext()) {
                    RecognizeEntitiesResult entitiesResult = (RecognizeEntitiesResult)iterator.next();
                    if (entitiesResult.isError()) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(entitiesResult.getError())));
                    }
                    entityCollection = new CategorizedEntityCollection(entitiesResult.getEntities(), entitiesResult.getEntities().getWarnings());
                }
                return entityCollection;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RecognizeEntitiesResultCollection>> recognizeEntitiesBatch(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        try {
            Utility.inputDocumentsValidation(documents);
            return FluxUtil.withContext(context -> this.getRecognizedEntitiesResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RecognizeEntitiesResultCollection>> recognizeEntitiesBatchWithContext(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        try {
            Utility.inputDocumentsValidation(documents);
            return this.getRecognizedEntitiesResponse(documents, options, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Response<RecognizeEntitiesResultCollection> toRecognizeEntitiesResultCollectionResponse(Response<EntitiesResult> response) {
        EntitiesResult entitiesResult = (EntitiesResult)response.getValue();
        ArrayList<RecognizeEntitiesResult> recognizeEntitiesResults = new ArrayList<RecognizeEntitiesResult>();
        entitiesResult.getDocuments().forEach(documentEntities -> recognizeEntitiesResults.add(new RecognizeEntitiesResult(documentEntities.getId(), documentEntities.getStatistics() == null ? null : Utility.toTextDocumentStatistics(documentEntities.getStatistics()), null, new CategorizedEntityCollection((IterableStream<CategorizedEntity>)new IterableStream((Iterable)documentEntities.getEntities().stream().map(entity -> {
            CategorizedEntity categorizedEntity = new CategorizedEntity(entity.getText(), EntityCategory.fromString(entity.getCategory()), entity.getSubcategory(), entity.getConfidenceScore());
            CategorizedEntityPropertiesHelper.setLength(categorizedEntity, entity.getLength());
            CategorizedEntityPropertiesHelper.setOffset(categorizedEntity, entity.getOffset());
            return categorizedEntity;
        }).collect(Collectors.toList())), (IterableStream<TextAnalyticsWarning>)new IterableStream((Iterable)documentEntities.getWarnings().stream().map(warning -> {
            WarningCodeValue warningCodeValue = warning.getCode();
            return new TextAnalyticsWarning(WarningCode.fromString(warningCodeValue == null ? null : warningCodeValue.toString()), warning.getMessage());
        }).collect(Collectors.toList()))))));
        for (DocumentError documentError : entitiesResult.getErrors()) {
            recognizeEntitiesResults.add(new RecognizeEntitiesResult(documentError.getId(), null, Utility.toTextAnalyticsError(documentError.getError()), null));
        }
        return new SimpleResponse(response, (Object)new RecognizeEntitiesResultCollection(recognizeEntitiesResults, entitiesResult.getModelVersion(), entitiesResult.getStatistics() == null ? null : Utility.toBatchStatistics(entitiesResult.getStatistics())));
    }

    private Mono<Response<RecognizeEntitiesResultCollection>> getRecognizedEntitiesResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options, Context context) {
        options = options == null ? new TextAnalyticsRequestOptions() : options;
        return this.service.entitiesRecognitionGeneralWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), options.getModelVersion(), options.isIncludeStatistics(), options.isServiceLogsDisabled(), StringIndexType.UTF16CODE_UNIT, Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices")).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> this.logger.info("Recognized entities for a batch of documents- {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to recognize entities - {}", new Object[]{error})).map(this::toRecognizeEntitiesResultCollectionResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }
}

