/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.AnalyzeActionsAsyncClient;
import com.azure.ai.textanalytics.AnalyzeHealthcareEntityAsyncClient;
import com.azure.ai.textanalytics.AnalyzeSentimentAsyncClient;
import com.azure.ai.textanalytics.DetectLanguageAsyncClient;
import com.azure.ai.textanalytics.ExtractKeyPhraseAsyncClient;
import com.azure.ai.textanalytics.RecognizeEntityAsyncClient;
import com.azure.ai.textanalytics.RecognizeLinkedEntityAsyncClient;
import com.azure.ai.textanalytics.RecognizePiiEntityAsyncClient;
import com.azure.ai.textanalytics.TextAnalyticsClientBuilder;
import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.models.AnalyzeActionsOperationDetail;
import com.azure.ai.textanalytics.models.AnalyzeActionsOptions;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesOperationDetail;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesOptions;
import com.azure.ai.textanalytics.models.AnalyzeSentimentOptions;
import com.azure.ai.textanalytics.models.AnalyzeSentimentResult;
import com.azure.ai.textanalytics.models.CategorizedEntityCollection;
import com.azure.ai.textanalytics.models.DetectLanguageInput;
import com.azure.ai.textanalytics.models.DetectLanguageResult;
import com.azure.ai.textanalytics.models.DetectedLanguage;
import com.azure.ai.textanalytics.models.DocumentSentiment;
import com.azure.ai.textanalytics.models.KeyPhrasesCollection;
import com.azure.ai.textanalytics.models.LinkedEntityCollection;
import com.azure.ai.textanalytics.models.PiiEntityCollection;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsActions;
import com.azure.ai.textanalytics.models.TextAnalyticsRequestOptions;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.AnalyzeActionsResultPagedFlux;
import com.azure.ai.textanalytics.util.AnalyzeHealthcareEntitiesPagedFlux;
import com.azure.ai.textanalytics.util.AnalyzeSentimentResultCollection;
import com.azure.ai.textanalytics.util.DetectLanguageResultCollection;
import com.azure.ai.textanalytics.util.ExtractKeyPhrasesResultCollection;
import com.azure.ai.textanalytics.util.RecognizeEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizeLinkedEntitiesResultCollection;
import com.azure.ai.textanalytics.util.RecognizePiiEntitiesResultCollection;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=TextAnalyticsClientBuilder.class, isAsync=true)
public final class TextAnalyticsAsyncClient {
    private final ClientLogger logger = new ClientLogger(TextAnalyticsAsyncClient.class);
    private final TextAnalyticsClientImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;
    private final String defaultCountryHint;
    private final String defaultLanguage;
    static final String COGNITIVE_TRACING_NAMESPACE_VALUE = "Microsoft.CognitiveServices";
    final DetectLanguageAsyncClient detectLanguageAsyncClient;
    final AnalyzeSentimentAsyncClient analyzeSentimentAsyncClient;
    final ExtractKeyPhraseAsyncClient extractKeyPhraseAsyncClient;
    final RecognizeEntityAsyncClient recognizeEntityAsyncClient;
    final RecognizePiiEntityAsyncClient recognizePiiEntityAsyncClient;
    final RecognizeLinkedEntityAsyncClient recognizeLinkedEntityAsyncClient;
    final AnalyzeHealthcareEntityAsyncClient analyzeHealthcareEntityAsyncClient;
    final AnalyzeActionsAsyncClient analyzeActionsAsyncClient;

    TextAnalyticsAsyncClient(TextAnalyticsClientImpl service, TextAnalyticsServiceVersion serviceVersion, String defaultCountryHint, String defaultLanguage) {
        this.service = service;
        this.serviceVersion = serviceVersion;
        this.defaultCountryHint = defaultCountryHint;
        this.defaultLanguage = defaultLanguage;
        this.detectLanguageAsyncClient = new DetectLanguageAsyncClient(service);
        this.analyzeSentimentAsyncClient = new AnalyzeSentimentAsyncClient(service);
        this.extractKeyPhraseAsyncClient = new ExtractKeyPhraseAsyncClient(service);
        this.recognizeEntityAsyncClient = new RecognizeEntityAsyncClient(service);
        this.recognizePiiEntityAsyncClient = new RecognizePiiEntityAsyncClient(service);
        this.recognizeLinkedEntityAsyncClient = new RecognizeLinkedEntityAsyncClient(service);
        this.analyzeHealthcareEntityAsyncClient = new AnalyzeHealthcareEntityAsyncClient(service);
        this.analyzeActionsAsyncClient = new AnalyzeActionsAsyncClient(service);
    }

    public String getDefaultCountryHint() {
        return this.defaultCountryHint;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DetectedLanguage> detectLanguage(String document) {
        return this.detectLanguage(document, this.defaultCountryHint);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DetectedLanguage> detectLanguage(String document, String countryHint) {
        try {
            Objects.requireNonNull(document, "'document' cannot be null.");
            return this.detectLanguageBatch(Collections.singletonList(document), countryHint, null).map(detectLanguageResultCollection -> {
                DetectedLanguage detectedLanguage = null;
                Iterator iterator = detectLanguageResultCollection.iterator();
                while (iterator.hasNext()) {
                    DetectLanguageResult detectLanguageResult = (DetectLanguageResult)iterator.next();
                    if (detectLanguageResult.isError()) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(detectLanguageResult.getError())));
                    }
                    detectedLanguage = detectLanguageResult.getPrimaryLanguage();
                }
                return detectedLanguage;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DetectLanguageResultCollection> detectLanguageBatch(Iterable<String> documents, String countryHint, TextAnalyticsRequestOptions options) {
        if (countryHint != null && "none".equalsIgnoreCase(countryHint)) {
            countryHint = "";
        }
        String finalCountryHint = countryHint;
        try {
            return this.detectLanguageBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> new DetectLanguageInput((String)index, (String)value, finalCountryHint)), options).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DetectLanguageResultCollection>> detectLanguageBatchWithResponse(Iterable<DetectLanguageInput> documents, TextAnalyticsRequestOptions options) {
        return this.detectLanguageAsyncClient.detectLanguageBatch(documents, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CategorizedEntityCollection> recognizeEntities(String document) {
        return this.recognizeEntities(document, this.defaultLanguage);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CategorizedEntityCollection> recognizeEntities(String document, String language) {
        return this.recognizeEntityAsyncClient.recognizeEntities(document, language);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecognizeEntitiesResultCollection> recognizeEntitiesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        try {
            return this.recognizeEntitiesBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
                TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
                textDocumentInput.setLanguage(language);
                return textDocumentInput;
            }), options).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecognizeEntitiesResultCollection>> recognizeEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        return this.recognizeEntityAsyncClient.recognizeEntitiesBatch(documents, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PiiEntityCollection> recognizePiiEntities(String document) {
        return this.recognizePiiEntities(document, this.defaultLanguage);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PiiEntityCollection> recognizePiiEntities(String document, String language) {
        return this.recognizePiiEntityAsyncClient.recognizePiiEntities(document, language, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PiiEntityCollection> recognizePiiEntities(String document, String language, RecognizePiiEntitiesOptions options) {
        return this.recognizePiiEntityAsyncClient.recognizePiiEntities(document, language, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecognizePiiEntitiesResultCollection> recognizePiiEntitiesBatch(Iterable<String> documents, String language, RecognizePiiEntitiesOptions options) {
        try {
            Utility.inputDocumentsValidation(documents);
            return this.recognizePiiEntitiesBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
                TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
                textDocumentInput.setLanguage(language);
                return textDocumentInput;
            }), options).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecognizePiiEntitiesResultCollection>> recognizePiiEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, RecognizePiiEntitiesOptions options) {
        return this.recognizePiiEntityAsyncClient.recognizePiiEntitiesBatch(documents, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedEntityCollection> recognizeLinkedEntities(String document) {
        return this.recognizeLinkedEntities(document, this.defaultLanguage);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedEntityCollection> recognizeLinkedEntities(String document, String language) {
        return this.recognizeLinkedEntityAsyncClient.recognizeLinkedEntities(document, language);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecognizeLinkedEntitiesResultCollection> recognizeLinkedEntitiesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        try {
            return this.recognizeLinkedEntitiesBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
                TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
                textDocumentInput.setLanguage(language);
                return textDocumentInput;
            }), options).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecognizeLinkedEntitiesResultCollection>> recognizeLinkedEntitiesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        return this.recognizeLinkedEntityAsyncClient.recognizeLinkedEntitiesBatch(documents, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyPhrasesCollection> extractKeyPhrases(String document) {
        return this.extractKeyPhrases(document, this.defaultLanguage);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyPhrasesCollection> extractKeyPhrases(String document, String language) {
        return this.extractKeyPhraseAsyncClient.extractKeyPhrasesSingleText(document, language);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExtractKeyPhrasesResultCollection> extractKeyPhrasesBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        try {
            return this.extractKeyPhrasesBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
                TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
                textDocumentInput.setLanguage(language);
                return textDocumentInput;
            }), options).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExtractKeyPhrasesResultCollection>> extractKeyPhrasesBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        return this.extractKeyPhraseAsyncClient.extractKeyPhrasesWithResponse(documents, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentSentiment> analyzeSentiment(String document) {
        return this.analyzeSentiment(document, this.defaultLanguage);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentSentiment> analyzeSentiment(String document, String language) {
        return this.analyzeSentiment(document, language, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentSentiment> analyzeSentiment(String document, String language, AnalyzeSentimentOptions options) {
        try {
            Objects.requireNonNull(document, "'document' cannot be null.");
            return this.analyzeSentimentBatch(Collections.singletonList(document), language, options).map(sentimentResultCollection -> {
                DocumentSentiment documentSentiment = null;
                Iterator iterator = sentimentResultCollection.iterator();
                while (iterator.hasNext()) {
                    AnalyzeSentimentResult sentimentResult = (AnalyzeSentimentResult)iterator.next();
                    if (sentimentResult.isError()) {
                        throw this.logger.logExceptionAsError((RuntimeException)((Object)Utility.toTextAnalyticsException(sentimentResult.getError())));
                    }
                    documentSentiment = sentimentResult.getDocumentSentiment();
                }
                return documentSentiment;
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeSentimentResultCollection> analyzeSentimentBatch(Iterable<String> documents, String language, TextAnalyticsRequestOptions options) {
        return this.analyzeSentimentBatch(documents, language, new AnalyzeSentimentOptions().setIncludeStatistics(options == null ? false : options.isIncludeStatistics()).setModelVersion(options == null ? null : options.getModelVersion()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeSentimentResultCollection> analyzeSentimentBatch(Iterable<String> documents, String language, AnalyzeSentimentOptions options) {
        try {
            return this.analyzeSentimentBatchWithResponse(Utility.mapByIndex(documents, (index, value) -> {
                TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
                textDocumentInput.setLanguage(language);
                return textDocumentInput;
            }), options).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeSentimentResultCollection>> analyzeSentimentBatchWithResponse(Iterable<TextDocumentInput> documents, TextAnalyticsRequestOptions options) {
        return this.analyzeSentimentAsyncClient.analyzeSentimentBatch(documents, new AnalyzeSentimentOptions().setIncludeStatistics(options == null ? false : options.isIncludeStatistics()).setModelVersion(options == null ? null : options.getModelVersion()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnalyzeSentimentResultCollection>> analyzeSentimentBatchWithResponse(Iterable<TextDocumentInput> documents, AnalyzeSentimentOptions options) {
        return this.analyzeSentimentAsyncClient.analyzeSentimentBatch(documents, options);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedFlux> beginAnalyzeHealthcareEntities(Iterable<String> documents, String language, AnalyzeHealthcareEntitiesOptions options) {
        return this.beginAnalyzeHealthcareEntities(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), options);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AnalyzeHealthcareEntitiesOperationDetail, AnalyzeHealthcareEntitiesPagedFlux> beginAnalyzeHealthcareEntities(Iterable<TextDocumentInput> documents, AnalyzeHealthcareEntitiesOptions options) {
        return this.analyzeHealthcareEntityAsyncClient.beginAnalyzeHealthcareEntities(documents, options, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedFlux> beginAnalyzeActions(Iterable<String> documents, TextAnalyticsActions actions, String language, AnalyzeActionsOptions options) {
        return this.beginAnalyzeActions(Utility.mapByIndex(documents, (index, value) -> {
            TextDocumentInput textDocumentInput = new TextDocumentInput((String)index, (String)value);
            textDocumentInput.setLanguage(language);
            return textDocumentInput;
        }), actions, options);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PollerFlux<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedFlux> beginAnalyzeActions(Iterable<TextDocumentInput> documents, TextAnalyticsActions actions, AnalyzeActionsOptions options) {
        return this.analyzeActionsAsyncClient.beginAnalyzeActions(documents, actions, options, Context.NONE);
    }
}

