/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.implementation.AnalyzeActionsOperationDetailPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AnalyzeActionsResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AnalyzeHealthcareEntitiesActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AnalyzeSentimentActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AnalyzeTextsImpl;
import com.azure.ai.textanalytics.implementation.ExtractKeyPhrasesActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.ExtractSummaryActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.MultiCategoryClassifyActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.RecognizeCustomEntitiesActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.RecognizeEntitiesActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.RecognizeLinkedEntitiesActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.RecognizePiiEntitiesActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.SingleCategoryClassifyActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TextAnalyticsActionResultPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeBatchInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeHeaders;
import com.azure.ai.textanalytics.implementation.models.AnalyzeJobState;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobState;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobsInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsSubmitJobHeaders;
import com.azure.ai.textanalytics.implementation.models.CustomEntitiesLROTask;
import com.azure.ai.textanalytics.implementation.models.CustomEntitiesResult;
import com.azure.ai.textanalytics.implementation.models.CustomEntitiesTask;
import com.azure.ai.textanalytics.implementation.models.CustomEntitiesTaskParameters;
import com.azure.ai.textanalytics.implementation.models.CustomEntityRecognitionLROResult;
import com.azure.ai.textanalytics.implementation.models.CustomMultiClassificationTask;
import com.azure.ai.textanalytics.implementation.models.CustomMultiLabelClassificationLROResult;
import com.azure.ai.textanalytics.implementation.models.CustomMultiLabelClassificationLROTask;
import com.azure.ai.textanalytics.implementation.models.CustomMultiLabelClassificationResult;
import com.azure.ai.textanalytics.implementation.models.CustomMultiLabelClassificationTaskParameters;
import com.azure.ai.textanalytics.implementation.models.CustomSingleClassificationTask;
import com.azure.ai.textanalytics.implementation.models.CustomSingleLabelClassificationLROResult;
import com.azure.ai.textanalytics.implementation.models.CustomSingleLabelClassificationLROTask;
import com.azure.ai.textanalytics.implementation.models.CustomSingleLabelClassificationResult;
import com.azure.ai.textanalytics.implementation.models.CustomSingleLabelClassificationTaskParameters;
import com.azure.ai.textanalytics.implementation.models.EntitiesLROTask;
import com.azure.ai.textanalytics.implementation.models.EntitiesResult;
import com.azure.ai.textanalytics.implementation.models.EntitiesTask;
import com.azure.ai.textanalytics.implementation.models.EntitiesTaskParameters;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingLROResult;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingLROTask;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingResult;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingTask;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingTaskParameters;
import com.azure.ai.textanalytics.implementation.models.EntityRecognitionLROResult;
import com.azure.ai.textanalytics.implementation.models.Error;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationLROResult;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationLROTask;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationResult;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationSortingCriteria;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationTask;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationTaskParameters;
import com.azure.ai.textanalytics.implementation.models.FhirVersion;
import com.azure.ai.textanalytics.implementation.models.HealthcareLROResult;
import com.azure.ai.textanalytics.implementation.models.HealthcareLROTask;
import com.azure.ai.textanalytics.implementation.models.HealthcareResult;
import com.azure.ai.textanalytics.implementation.models.HealthcareTaskParameters;
import com.azure.ai.textanalytics.implementation.models.JobManifestTasks;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseExtractionLROResult;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseLROTask;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseResult;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseTaskParameters;
import com.azure.ai.textanalytics.implementation.models.KeyPhrasesTask;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.PiiDomain;
import com.azure.ai.textanalytics.implementation.models.PiiEntityRecognitionLROResult;
import com.azure.ai.textanalytics.implementation.models.PiiLROTask;
import com.azure.ai.textanalytics.implementation.models.PiiResult;
import com.azure.ai.textanalytics.implementation.models.PiiTask;
import com.azure.ai.textanalytics.implementation.models.PiiTaskParameters;
import com.azure.ai.textanalytics.implementation.models.PreBuiltResult;
import com.azure.ai.textanalytics.implementation.models.SentimentAnalysisLROTask;
import com.azure.ai.textanalytics.implementation.models.SentimentAnalysisTask;
import com.azure.ai.textanalytics.implementation.models.SentimentAnalysisTaskParameters;
import com.azure.ai.textanalytics.implementation.models.SentimentLROResult;
import com.azure.ai.textanalytics.implementation.models.SentimentResponse;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.implementation.models.TaskState;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasks;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasksEntityLinkingTasksItem;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasksEntityRecognitionPiiTasksItem;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasksEntityRecognitionTasksItem;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasksKeyPhraseExtractionTasksItem;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasksOld;
import com.azure.ai.textanalytics.implementation.models.TasksStateTasksSentimentAnalysisTasksItem;
import com.azure.ai.textanalytics.models.AnalyzeActionsOperationDetail;
import com.azure.ai.textanalytics.models.AnalyzeActionsOptions;
import com.azure.ai.textanalytics.models.AnalyzeActionsResult;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesAction;
import com.azure.ai.textanalytics.models.AnalyzeHealthcareEntitiesActionResult;
import com.azure.ai.textanalytics.models.AnalyzeSentimentAction;
import com.azure.ai.textanalytics.models.AnalyzeSentimentActionResult;
import com.azure.ai.textanalytics.models.ExtractKeyPhrasesAction;
import com.azure.ai.textanalytics.models.ExtractKeyPhrasesActionResult;
import com.azure.ai.textanalytics.models.ExtractSummaryAction;
import com.azure.ai.textanalytics.models.ExtractSummaryActionResult;
import com.azure.ai.textanalytics.models.MultiCategoryClassifyAction;
import com.azure.ai.textanalytics.models.MultiCategoryClassifyActionResult;
import com.azure.ai.textanalytics.models.RecognizeCustomEntitiesAction;
import com.azure.ai.textanalytics.models.RecognizeCustomEntitiesActionResult;
import com.azure.ai.textanalytics.models.RecognizeEntitiesAction;
import com.azure.ai.textanalytics.models.RecognizeEntitiesActionResult;
import com.azure.ai.textanalytics.models.RecognizeLinkedEntitiesAction;
import com.azure.ai.textanalytics.models.RecognizeLinkedEntitiesActionResult;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesAction;
import com.azure.ai.textanalytics.models.RecognizePiiEntitiesActionResult;
import com.azure.ai.textanalytics.models.SingleCategoryClassifyAction;
import com.azure.ai.textanalytics.models.SingleCategoryClassifyActionResult;
import com.azure.ai.textanalytics.models.TextAnalyticsActionResult;
import com.azure.ai.textanalytics.models.TextAnalyticsActions;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsErrorCode;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.AnalyzeActionsResultPagedFlux;
import com.azure.ai.textanalytics.util.AnalyzeActionsResultPagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.core.publisher.Mono;

class AnalyzeActionsAsyncClient {
    private static final String ENTITY_RECOGNITION_TASKS = "entityRecognitionTasks";
    private static final String ENTITY_RECOGNITION_PII_TASKS = "entityRecognitionPiiTasks";
    private static final String KEY_PHRASE_EXTRACTION_TASKS = "keyPhraseExtractionTasks";
    private static final String ENTITY_LINKING_TASKS = "entityLinkingTasks";
    private static final String SENTIMENT_ANALYSIS_TASKS = "sentimentAnalysisTasks";
    private static final String EXTRACTIVE_SUMMARIZATION_TASKS = "extractiveSummarizationTasks";
    private static final String CUSTOM_ENTITY_RECOGNITION_TASKS = "customEntityRecognitionTasks";
    private static final String CUSTOM_SINGLE_CLASSIFICATION_TASKS = "customClassificationTasks";
    private static final String CUSTOM_MULTI_CLASSIFICATION_TASKS = "customMultiClassificationTasks";
    private static final String REGEX_ACTION_ERROR_TARGET = String.format("#/tasks/(%s|%s|%s|%s|%s|%s|%s|%s|%s)/(\\d+)", "keyPhraseExtractionTasks", "entityRecognitionPiiTasks", "entityRecognitionTasks", "entityLinkingTasks", "sentimentAnalysisTasks", "extractiveSummarizationTasks", "customEntityRecognitionTasks", "customClassificationTasks", "customMultiClassificationTasks");
    private final ClientLogger logger = new ClientLogger(AnalyzeActionsAsyncClient.class);
    private final TextAnalyticsClientImpl legacyService;
    private final AnalyzeTextsImpl service;
    private static final Pattern PATTERN = Pattern.compile(REGEX_ACTION_ERROR_TARGET, 8);

    AnalyzeActionsAsyncClient(TextAnalyticsClientImpl legacyService) {
        this.legacyService = legacyService;
        this.service = null;
    }

    AnalyzeActionsAsyncClient(AnalyzeTextsImpl service) {
        this.legacyService = null;
        this.service = service;
    }

    PollerFlux<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedFlux> beginAnalyzeActions(Iterable<TextDocumentInput> documents, TextAnalyticsActions actions, AnalyzeActionsOptions options, Context context) {
        try {
            Objects.requireNonNull(actions, "'actions' cannot be null.");
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullAnalyzeActionsOptions(options);
            Context finalContext = this.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices");
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            if (this.service != null) {
                AnalyzeTextJobsInput analyzeTextJobsInput = new AnalyzeTextJobsInput().setDisplayName(actions.getDisplayName()).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(this.getAnalyzeTextLROTasks(actions));
                return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AnalyzeActionsOperationDetail>)this.service.submitJobWithResponseAsync(analyzeTextJobsInput, finalContext).map(analyzeResponse -> {
                    AnalyzeActionsOperationDetail textAnalyticsOperationResult = new AnalyzeActionsOperationDetail();
                    AnalyzeActionsOperationDetailPropertiesHelper.setOperationId(textAnalyticsOperationResult, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)analyzeResponse.getDeserializedHeaders()).getOperationLocation()));
                    return textAnalyticsOperationResult;
                })), this.pollingOperationLanguageApi(operationId -> this.service.jobStatusWithResponseAsync((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), (pollingContext, pollResponse) -> Mono.just((Object)((AnalyzeActionsOperationDetail)pollingContext.getLatestResponse().getValue())), this.fetchingOperation(operationId -> Mono.just((Object)((Object)this.getAnalyzeOperationFluxPage((UUID)operationId, null, null, finalIncludeStatistics, finalContext)))));
            }
            AnalyzeBatchInput analyzeBatchInput = new AnalyzeBatchInput().setAnalysisInput(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(this.getJobManifestTasks(actions));
            analyzeBatchInput.setDisplayName(actions.getDisplayName());
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AnalyzeActionsOperationDetail>)this.legacyService.analyzeWithResponseAsync(analyzeBatchInput, finalContext).map(analyzeResponse -> {
                AnalyzeActionsOperationDetail textAnalyticsOperationResult = new AnalyzeActionsOperationDetail();
                AnalyzeActionsOperationDetailPropertiesHelper.setOperationId(textAnalyticsOperationResult, Utility.parseOperationId(((AnalyzeHeaders)analyzeResponse.getDeserializedHeaders()).getOperationLocation()));
                return textAnalyticsOperationResult;
            })), this.pollingOperation(operationId -> this.legacyService.analyzeStatusWithResponseAsync(operationId.toString(), finalIncludeStatistics, null, null, finalContext)), (pollingContext, activationResponse) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported.")), this.fetchingOperation(operationId -> Mono.just((Object)((Object)this.getAnalyzeOperationFluxPage((UUID)operationId, null, null, finalIncludeStatistics, finalContext)))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    PollerFlux<AnalyzeActionsOperationDetail, AnalyzeActionsResultPagedIterable> beginAnalyzeActionsIterable(Iterable<TextDocumentInput> documents, TextAnalyticsActions actions, AnalyzeActionsOptions options, Context context) {
        try {
            Objects.requireNonNull(actions, "'actions' cannot be null.");
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullAnalyzeActionsOptions(options);
            Context finalContext = this.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices");
            AnalyzeBatchInput analyzeBatchInput = new AnalyzeBatchInput().setAnalysisInput(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(this.getJobManifestTasks(actions));
            analyzeBatchInput.setDisplayName(actions.getDisplayName());
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            if (this.service != null) {
                return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AnalyzeActionsOperationDetail>)this.service.submitJobWithResponseAsync(new AnalyzeTextJobsInput().setDisplayName(actions.getDisplayName()).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(this.getAnalyzeTextLROTasks(actions)), finalContext).map(analyzeResponse -> {
                    AnalyzeActionsOperationDetail operationDetail = new AnalyzeActionsOperationDetail();
                    AnalyzeActionsOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)analyzeResponse.getDeserializedHeaders()).getOperationLocation()));
                    return operationDetail;
                })), this.pollingOperationLanguageApi(operationId -> this.service.jobStatusWithResponseAsync((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported.")), this.fetchingOperationIterable(operationId -> Mono.just((Object)((Object)new AnalyzeActionsResultPagedIterable(this.getAnalyzeOperationFluxPage((UUID)operationId, null, null, finalIncludeStatistics, finalContext))))));
            }
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AnalyzeActionsOperationDetail>)this.legacyService.analyzeWithResponseAsync(analyzeBatchInput, finalContext).map(analyzeResponse -> {
                AnalyzeActionsOperationDetail operationDetail = new AnalyzeActionsOperationDetail();
                AnalyzeActionsOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeHeaders)analyzeResponse.getDeserializedHeaders()).getOperationLocation()));
                return operationDetail;
            })), this.pollingOperation(operationId -> this.legacyService.analyzeStatusWithResponseAsync(operationId.toString(), finalIncludeStatistics, null, null, finalContext)), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported.")), this.fetchingOperationIterable(operationId -> Mono.just((Object)((Object)new AnalyzeActionsResultPagedIterable(this.getAnalyzeOperationFluxPage((UUID)operationId, null, null, finalIncludeStatistics, finalContext))))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    private List<AnalyzeTextLROTask> getAnalyzeTextLROTasks(TextAnalyticsActions actions) {
        if (actions == null) {
            return null;
        }
        ArrayList<AnalyzeTextLROTask> tasks = new ArrayList<AnalyzeTextLROTask>();
        Iterable<RecognizeEntitiesAction> recognizeEntitiesActions = actions.getRecognizeEntitiesActions();
        Iterable<RecognizePiiEntitiesAction> recognizePiiEntitiesActions = actions.getRecognizePiiEntitiesActions();
        Iterable<ExtractKeyPhrasesAction> extractKeyPhrasesActions = actions.getExtractKeyPhrasesActions();
        Iterable<RecognizeLinkedEntitiesAction> recognizeLinkedEntitiesActions = actions.getRecognizeLinkedEntitiesActions();
        Iterable<AnalyzeHealthcareEntitiesAction> analyzeHealthcareEntitiesActions = actions.getAnalyzeHealthcareEntitiesActions();
        Iterable<AnalyzeSentimentAction> analyzeSentimentActions = actions.getAnalyzeSentimentActions();
        Iterable<ExtractSummaryAction> extractSummaryActions = actions.getExtractSummaryActions();
        Iterable<RecognizeCustomEntitiesAction> recognizeCustomEntitiesActions = actions.getRecognizeCustomEntitiesActions();
        Iterable<SingleCategoryClassifyAction> singleCategoryClassifyActions = actions.getSingleCategoryClassifyActions();
        Iterable<MultiCategoryClassifyAction> multiCategoryClassifyActions = actions.getMultiCategoryClassifyActions();
        if (recognizeEntitiesActions != null) {
            recognizeEntitiesActions.forEach(action -> tasks.add(this.toEntitiesLROTask((RecognizeEntitiesAction)action)));
        }
        if (recognizePiiEntitiesActions != null) {
            recognizePiiEntitiesActions.forEach(action -> tasks.add(this.toPiiLROTask((RecognizePiiEntitiesAction)action)));
        }
        if (analyzeHealthcareEntitiesActions != null) {
            analyzeHealthcareEntitiesActions.forEach(action -> tasks.add(this.toHealthcareLROTask((AnalyzeHealthcareEntitiesAction)action)));
        }
        if (extractKeyPhrasesActions != null) {
            extractKeyPhrasesActions.forEach(action -> tasks.add(this.toKeyPhraseLROTask((ExtractKeyPhrasesAction)action)));
        }
        if (recognizeLinkedEntitiesActions != null) {
            recognizeLinkedEntitiesActions.forEach(action -> tasks.add(this.toEntityLinkingLROTask((RecognizeLinkedEntitiesAction)action)));
        }
        if (analyzeSentimentActions != null) {
            analyzeSentimentActions.forEach(action -> tasks.add(this.toSentimentAnalysisLROTask((AnalyzeSentimentAction)action)));
        }
        if (extractSummaryActions != null) {
            extractSummaryActions.forEach(action -> tasks.add(this.toExtractiveSummarizationLROTask((ExtractSummaryAction)action)));
        }
        if (recognizeCustomEntitiesActions != null) {
            recognizeCustomEntitiesActions.forEach(action -> tasks.add(this.toCustomEntitiesLROTask((RecognizeCustomEntitiesAction)action)));
        }
        if (singleCategoryClassifyActions != null) {
            singleCategoryClassifyActions.forEach(action -> tasks.add(this.toCustomSingleLabelClassificationLROTask((SingleCategoryClassifyAction)action)));
        }
        if (multiCategoryClassifyActions != null) {
            multiCategoryClassifyActions.forEach(action -> tasks.add(this.toCustomMultiLabelClassificationLROTask((MultiCategoryClassifyAction)action)));
        }
        return tasks;
    }

    private JobManifestTasks getJobManifestTasks(TextAnalyticsActions actions) {
        if (actions == null) {
            return null;
        }
        JobManifestTasks jobManifestTasks = new JobManifestTasks();
        if (actions.getRecognizeEntitiesActions() != null) {
            jobManifestTasks.setEntityRecognitionTasks(this.toEntitiesTasks(actions));
        }
        if (actions.getRecognizePiiEntitiesActions() != null) {
            jobManifestTasks.setEntityRecognitionPiiTasks(this.toPiiTasks(actions));
        }
        if (actions.getExtractKeyPhrasesActions() != null) {
            jobManifestTasks.setKeyPhraseExtractionTasks(this.toKeyPhrasesTasks(actions));
        }
        if (actions.getRecognizeLinkedEntitiesActions() != null) {
            jobManifestTasks.setEntityLinkingTasks(this.toEntityLinkingTasks(actions));
        }
        if (actions.getAnalyzeSentimentActions() != null) {
            jobManifestTasks.setSentimentAnalysisTasks(this.toSentimentAnalysisTasks(actions));
        }
        if (actions.getExtractSummaryActions() != null) {
            jobManifestTasks.setExtractiveSummarizationTasks(this.toExtractiveSummarizationTask(actions));
        }
        if (actions.getRecognizeCustomEntitiesActions() != null) {
            jobManifestTasks.setCustomEntityRecognitionTasks(this.toCustomEntitiesTask(actions));
        }
        if (actions.getSingleCategoryClassifyActions() != null) {
            jobManifestTasks.setCustomSingleClassificationTasks(this.toCustomSingleClassificationTask(actions));
        }
        if (actions.getMultiCategoryClassifyActions() != null) {
            jobManifestTasks.setCustomMultiClassificationTasks(this.toCustomMultiClassificationTask(actions));
        }
        return jobManifestTasks;
    }

    private EntitiesLROTask toEntitiesLROTask(RecognizeEntitiesAction action) {
        if (action == null) {
            return null;
        }
        EntitiesLROTask task = new EntitiesLROTask();
        task.setParameters(this.getEntitiesTaskParameters(action)).setTaskName(action.getActionName());
        return task;
    }

    private List<EntitiesTask> toEntitiesTasks(TextAnalyticsActions actions) {
        ArrayList<EntitiesTask> entitiesTasks = new ArrayList<EntitiesTask>();
        for (RecognizeEntitiesAction action : actions.getRecognizeEntitiesActions()) {
            entitiesTasks.add(action == null ? null : new EntitiesTask().setTaskName(action.getActionName()).setParameters(this.getEntitiesTaskParameters(action)));
        }
        return entitiesTasks;
    }

    private EntitiesTaskParameters getEntitiesTaskParameters(RecognizeEntitiesAction action) {
        return (EntitiesTaskParameters)new EntitiesTaskParameters().setStringIndexType(StringIndexType.UTF16CODE_UNIT).setModelVersion(action.getModelVersion()).setLoggingOptOut(action.isServiceLogsDisabled());
    }

    private PiiLROTask toPiiLROTask(RecognizePiiEntitiesAction action) {
        if (action == null) {
            return null;
        }
        PiiLROTask task = new PiiLROTask();
        task.setParameters(this.getPiiTaskParameters(action)).setTaskName(action.getActionName());
        return task;
    }

    private List<PiiTask> toPiiTasks(TextAnalyticsActions actions) {
        ArrayList<PiiTask> piiTasks = new ArrayList<PiiTask>();
        for (RecognizePiiEntitiesAction action : actions.getRecognizePiiEntitiesActions()) {
            piiTasks.add(action == null ? null : new PiiTask().setTaskName(action.getActionName()).setParameters(this.getPiiTaskParameters(action)));
        }
        return piiTasks;
    }

    private PiiTaskParameters getPiiTaskParameters(RecognizePiiEntitiesAction action) {
        return (PiiTaskParameters)new PiiTaskParameters().setStringIndexType(StringIndexType.UTF16CODE_UNIT).setDomain(PiiDomain.fromString(action.getDomainFilter() == null ? null : action.getDomainFilter().toString())).setPiiCategories(Utility.toCategoriesFilter(action.getCategoriesFilter())).setModelVersion(action.getModelVersion()).setLoggingOptOut(action.isServiceLogsDisabled());
    }

    private HealthcareLROTask toHealthcareLROTask(AnalyzeHealthcareEntitiesAction action) {
        if (action == null) {
            return null;
        }
        HealthcareLROTask task = new HealthcareLROTask();
        task.setParameters(this.getHealthcareTaskParameters(action)).setTaskName(action.getActionName());
        return task;
    }

    private HealthcareTaskParameters getHealthcareTaskParameters(AnalyzeHealthcareEntitiesAction action) {
        com.azure.ai.textanalytics.models.FhirVersion fhirVersion = action.getFhirVersion();
        FhirVersion fhirVersionImpl = fhirVersion == null ? null : FhirVersion.fromString(fhirVersion.toString());
        return (HealthcareTaskParameters)new HealthcareTaskParameters().setFhirVersion(fhirVersionImpl).setStringIndexType(StringIndexType.UTF16CODE_UNIT).setModelVersion(action.getModelVersion()).setLoggingOptOut(action.isServiceLogsDisabled());
    }

    private KeyPhraseLROTask toKeyPhraseLROTask(ExtractKeyPhrasesAction action) {
        if (action == null) {
            return null;
        }
        KeyPhraseLROTask task = new KeyPhraseLROTask();
        task.setParameters(this.getKeyPhraseTaskParameters(action)).setTaskName(action.getActionName());
        return task;
    }

    private List<KeyPhrasesTask> toKeyPhrasesTasks(TextAnalyticsActions actions) {
        ArrayList<KeyPhrasesTask> keyPhrasesTasks = new ArrayList<KeyPhrasesTask>();
        for (ExtractKeyPhrasesAction action : actions.getExtractKeyPhrasesActions()) {
            keyPhrasesTasks.add(action == null ? null : new KeyPhrasesTask().setTaskName(action.getActionName()).setParameters(this.getKeyPhraseTaskParameters(action)));
        }
        return keyPhrasesTasks;
    }

    private KeyPhraseTaskParameters getKeyPhraseTaskParameters(ExtractKeyPhrasesAction action) {
        return (KeyPhraseTaskParameters)new KeyPhraseTaskParameters().setModelVersion(action.getModelVersion()).setLoggingOptOut(action.isServiceLogsDisabled());
    }

    private EntityLinkingLROTask toEntityLinkingLROTask(RecognizeLinkedEntitiesAction action) {
        if (action == null) {
            return null;
        }
        EntityLinkingLROTask task = new EntityLinkingLROTask();
        task.setParameters(this.getEntityLinkingTaskParameters(action)).setTaskName(action.getActionName());
        return task;
    }

    private List<EntityLinkingTask> toEntityLinkingTasks(TextAnalyticsActions actions) {
        ArrayList<EntityLinkingTask> tasks = new ArrayList<EntityLinkingTask>();
        for (RecognizeLinkedEntitiesAction action : actions.getRecognizeLinkedEntitiesActions()) {
            tasks.add(action == null ? null : new EntityLinkingTask().setTaskName(action.getActionName()).setParameters(this.getEntityLinkingTaskParameters(action)));
        }
        return tasks;
    }

    private EntityLinkingTaskParameters getEntityLinkingTaskParameters(RecognizeLinkedEntitiesAction action) {
        return (EntityLinkingTaskParameters)new EntityLinkingTaskParameters().setStringIndexType(StringIndexType.UTF16CODE_UNIT).setModelVersion(action.getModelVersion()).setLoggingOptOut(action.isServiceLogsDisabled());
    }

    private SentimentAnalysisLROTask toSentimentAnalysisLROTask(AnalyzeSentimentAction action) {
        if (action == null) {
            return null;
        }
        SentimentAnalysisLROTask task = new SentimentAnalysisLROTask();
        task.setParameters(this.getSentimentAnalysisTaskParameters(action)).setTaskName(action.getActionName());
        return task;
    }

    private List<SentimentAnalysisTask> toSentimentAnalysisTasks(TextAnalyticsActions actions) {
        ArrayList<SentimentAnalysisTask> tasks = new ArrayList<SentimentAnalysisTask>();
        for (AnalyzeSentimentAction action : actions.getAnalyzeSentimentActions()) {
            tasks.add(action == null ? null : new SentimentAnalysisTask().setTaskName(action.getActionName()).setParameters(this.getSentimentAnalysisTaskParameters(action)));
        }
        return tasks;
    }

    private SentimentAnalysisTaskParameters getSentimentAnalysisTaskParameters(AnalyzeSentimentAction action) {
        return (SentimentAnalysisTaskParameters)new SentimentAnalysisTaskParameters().setStringIndexType(StringIndexType.UTF16CODE_UNIT).setOpinionMining(action.isIncludeOpinionMining()).setModelVersion(action.getModelVersion()).setLoggingOptOut(action.isServiceLogsDisabled());
    }

    private ExtractiveSummarizationLROTask toExtractiveSummarizationLROTask(ExtractSummaryAction action) {
        if (action == null) {
            return null;
        }
        ExtractiveSummarizationLROTask task = new ExtractiveSummarizationLROTask();
        task.setParameters(this.getExtractiveSummarizationTaskParameters(action)).setTaskName(action.getActionName());
        return task;
    }

    private List<ExtractiveSummarizationTask> toExtractiveSummarizationTask(TextAnalyticsActions actions) {
        ArrayList<ExtractiveSummarizationTask> extractiveSummarizationTasks = new ArrayList<ExtractiveSummarizationTask>();
        for (ExtractSummaryAction action : actions.getExtractSummaryActions()) {
            extractiveSummarizationTasks.add(action == null ? null : new ExtractiveSummarizationTask().setTaskName(action.getActionName()).setParameters(this.getExtractiveSummarizationTaskParameters(action)));
        }
        return extractiveSummarizationTasks;
    }

    private ExtractiveSummarizationTaskParameters getExtractiveSummarizationTaskParameters(ExtractSummaryAction action) {
        return (ExtractiveSummarizationTaskParameters)new ExtractiveSummarizationTaskParameters().setStringIndexType(StringIndexType.UTF16CODE_UNIT).setSentenceCount(action.getMaxSentenceCount()).setSortBy(action.getOrderBy() == null ? null : ExtractiveSummarizationSortingCriteria.fromString(action.getOrderBy().toString())).setModelVersion(action.getModelVersion()).setLoggingOptOut(action.isServiceLogsDisabled());
    }

    private CustomEntitiesLROTask toCustomEntitiesLROTask(RecognizeCustomEntitiesAction action) {
        if (action == null) {
            return null;
        }
        CustomEntitiesLROTask task = new CustomEntitiesLROTask();
        task.setParameters(this.getCustomEntitiesTaskParameters(action)).setTaskName(action.getActionName());
        return task;
    }

    private List<CustomEntitiesTask> toCustomEntitiesTask(TextAnalyticsActions actions) {
        ArrayList<CustomEntitiesTask> tasks = new ArrayList<CustomEntitiesTask>();
        for (RecognizeCustomEntitiesAction action : actions.getRecognizeCustomEntitiesActions()) {
            tasks.add(action == null ? null : new CustomEntitiesTask().setTaskName(action.getActionName()).setParameters(this.getCustomEntitiesTaskParameters(action)));
        }
        return tasks;
    }

    private CustomEntitiesTaskParameters getCustomEntitiesTaskParameters(RecognizeCustomEntitiesAction action) {
        return (CustomEntitiesTaskParameters)new CustomEntitiesTaskParameters().setStringIndexType(StringIndexType.UTF16CODE_UNIT).setProjectName(action.getProjectName()).setDeploymentName(action.getDeploymentName()).setLoggingOptOut(action.isServiceLogsDisabled());
    }

    private CustomSingleLabelClassificationLROTask toCustomSingleLabelClassificationLROTask(SingleCategoryClassifyAction action) {
        if (action == null) {
            return null;
        }
        CustomSingleLabelClassificationLROTask task = new CustomSingleLabelClassificationLROTask();
        task.setParameters(this.getCustomSingleClassificationTaskParameters(action)).setTaskName(action.getActionName());
        return task;
    }

    private List<CustomSingleClassificationTask> toCustomSingleClassificationTask(TextAnalyticsActions actions) {
        ArrayList<CustomSingleClassificationTask> tasks = new ArrayList<CustomSingleClassificationTask>();
        for (SingleCategoryClassifyAction action : actions.getSingleCategoryClassifyActions()) {
            tasks.add(action == null ? null : new CustomSingleClassificationTask().setTaskName(action.getActionName()).setParameters(this.getCustomSingleClassificationTaskParameters(action)));
        }
        return tasks;
    }

    private CustomSingleLabelClassificationTaskParameters getCustomSingleClassificationTaskParameters(SingleCategoryClassifyAction action) {
        return (CustomSingleLabelClassificationTaskParameters)new CustomSingleLabelClassificationTaskParameters().setProjectName(action.getProjectName()).setDeploymentName(action.getDeploymentName()).setLoggingOptOut(action.isServiceLogsDisabled());
    }

    private CustomMultiLabelClassificationLROTask toCustomMultiLabelClassificationLROTask(MultiCategoryClassifyAction action) {
        if (action == null) {
            return null;
        }
        CustomMultiLabelClassificationLROTask task = new CustomMultiLabelClassificationLROTask();
        task.setParameters(this.getCustomMultiLabelClassificationTaskParameters(action)).setTaskName(action.getActionName());
        return task;
    }

    private List<CustomMultiClassificationTask> toCustomMultiClassificationTask(TextAnalyticsActions actions) {
        ArrayList<CustomMultiClassificationTask> tasks = new ArrayList<CustomMultiClassificationTask>();
        for (MultiCategoryClassifyAction action : actions.getMultiCategoryClassifyActions()) {
            tasks.add(action == null ? null : new CustomMultiClassificationTask().setTaskName(action.getActionName()).setParameters(this.getCustomMultiLabelClassificationTaskParameters(action)));
        }
        return tasks;
    }

    private CustomMultiLabelClassificationTaskParameters getCustomMultiLabelClassificationTaskParameters(MultiCategoryClassifyAction action) {
        return (CustomMultiLabelClassificationTaskParameters)new CustomMultiLabelClassificationTaskParameters().setProjectName(action.getProjectName()).setDeploymentName(action.getDeploymentName()).setLoggingOptOut(action.isServiceLogsDisabled());
    }

    private Function<PollingContext<AnalyzeActionsOperationDetail>, Mono<AnalyzeActionsOperationDetail>> activationOperation(Mono<AnalyzeActionsOperationDetail> operationResult) {
        return pollingContext -> {
            try {
                return operationResult.onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeActionsOperationDetail>, Mono<PollResponse<AnalyzeActionsOperationDetail>>> pollingOperation(Function<UUID, Mono<Response<AnalyzeJobState>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID operationId = UUID.fromString(((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue()).getOperationId());
                return ((Mono)pollingFunction.apply(operationId)).flatMap(modelResponse -> this.processAnalyzedModelResponse((Response<AnalyzeJobState>)modelResponse, (PollResponse<AnalyzeActionsOperationDetail>)operationResultPollResponse)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeActionsOperationDetail>, Mono<PollResponse<AnalyzeActionsOperationDetail>>> pollingOperationLanguageApi(Function<UUID, Mono<Response<AnalyzeTextJobState>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID operationId = UUID.fromString(((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue()).getOperationId());
                return ((Mono)pollingFunction.apply(operationId)).flatMap(modelResponse -> this.processAnalyzedModelResponseLanguageApi((Response<AnalyzeTextJobState>)modelResponse, (PollResponse<AnalyzeActionsOperationDetail>)operationResultPollResponse)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeActionsOperationDetail>, Mono<AnalyzeActionsResultPagedFlux>> fetchingOperation(Function<UUID, Mono<AnalyzeActionsResultPagedFlux>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID operationId = UUID.fromString(((AnalyzeActionsOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
                return (Mono)fetchingFunction.apply(operationId);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AnalyzeActionsOperationDetail>, Mono<AnalyzeActionsResultPagedIterable>> fetchingOperationIterable(Function<UUID, Mono<AnalyzeActionsResultPagedIterable>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID operationId = UUID.fromString(((AnalyzeActionsOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
                return (Mono)fetchingFunction.apply(operationId);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    AnalyzeActionsResultPagedFlux getAnalyzeOperationFluxPage(UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        return new AnalyzeActionsResultPagedFlux(() -> (continuationToken, pageSize) -> this.getPage((String)continuationToken, operationId, top, skip, showStats, context).flux());
    }

    Mono<PagedResponse<AnalyzeActionsResult>> getPage(String continuationToken, UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        if (continuationToken != null) {
            Map<String, Object> continuationTokenMap = Utility.parseNextLink(continuationToken);
            Integer topValue = continuationTokenMap.getOrDefault("$top", null);
            Integer skipValue = continuationTokenMap.getOrDefault("$skip", null);
            Boolean showStatsValue = (Boolean)continuationTokenMap.getOrDefault(showStats, false);
            if (this.service != null) {
                return this.service.jobStatusWithResponseAsync(operationId, showStatsValue, topValue, skipValue, context).map(this::toAnalyzeActionsResultPagedResponseLanguageApi).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            return this.legacyService.analyzeStatusWithResponseAsync(operationId.toString(), showStatsValue, topValue, skipValue, context).map(this::toAnalyzeActionsResultPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        if (this.service != null) {
            return this.service.jobStatusWithResponseAsync(operationId, showStats, top, skip, context).map(this::toAnalyzeActionsResultPagedResponseLanguageApi).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        return this.legacyService.analyzeStatusWithResponseAsync(operationId.toString(), showStats, top, skip, context).map(this::toAnalyzeActionsResultPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }

    private PagedResponse<AnalyzeActionsResult> toAnalyzeActionsResultPagedResponse(Response<AnalyzeJobState> response) {
        AnalyzeJobState analyzeJobState = (AnalyzeJobState)response.getValue();
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Arrays.asList(this.toAnalyzeActionsResult(analyzeJobState)), analyzeJobState.getNextLink(), null);
    }

    private PagedResponse<AnalyzeActionsResult> toAnalyzeActionsResultPagedResponseLanguageApi(Response<AnalyzeTextJobState> response) {
        AnalyzeTextJobState analyzeJobState = (AnalyzeTextJobState)response.getValue();
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Arrays.asList(this.toAnalyzeActionsResultLanguageApi(analyzeJobState)), analyzeJobState.getNextLink(), null);
    }

    private AnalyzeActionsResult toAnalyzeActionsResult(AnalyzeJobState analyzeJobState) {
        List<TextAnalyticsError> errors;
        PreBuiltResult results;
        TextAnalyticsActionResult actionResult;
        Object taskItem;
        int i;
        TasksStateTasksOld tasksStateTasks = analyzeJobState.getTasks();
        List<TasksStateTasksEntityRecognitionPiiTasksItem> piiTasksItems = tasksStateTasks.getEntityRecognitionPiiTasks();
        List<TasksStateTasksEntityRecognitionTasksItem> entityRecognitionTasksItems = tasksStateTasks.getEntityRecognitionTasks();
        List<TasksStateTasksKeyPhraseExtractionTasksItem> keyPhraseExtractionTasks = tasksStateTasks.getKeyPhraseExtractionTasks();
        List<TasksStateTasksEntityLinkingTasksItem> linkedEntityRecognitionTasksItems = tasksStateTasks.getEntityLinkingTasks();
        List<TasksStateTasksSentimentAnalysisTasksItem> sentimentAnalysisTasksItems = tasksStateTasks.getSentimentAnalysisTasks();
        ArrayList<RecognizeEntitiesActionResult> recognizeEntitiesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> recognizePiiEntitiesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> extractKeyPhrasesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> recognizeLinkedEntitiesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> analyzeSentimentActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList extractSummaryActionResults = new ArrayList();
        ArrayList recognizeCustomEntitiesActionResults = new ArrayList();
        ArrayList singleCategoryClassifyActionResults = new ArrayList();
        ArrayList multiCategoryClassifyActionResults = new ArrayList();
        if (!CoreUtils.isNullOrEmpty(entityRecognitionTasksItems)) {
            for (i = 0; i < entityRecognitionTasksItems.size(); ++i) {
                taskItem = entityRecognitionTasksItems.get(i);
                actionResult = new RecognizeEntitiesActionResult();
                results = ((TasksStateTasksEntityRecognitionTasksItem)taskItem).getResults();
                if (results != null) {
                    RecognizeEntitiesActionResultPropertiesHelper.setDocumentsResults(actionResult, Utility.toRecognizeEntitiesResultCollectionResponse(results));
                }
                TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, ((TaskState)taskItem).getTaskName());
                TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, ((TaskState)taskItem).getLastUpdateDateTime());
                recognizeEntitiesActionResults.add((RecognizeEntitiesActionResult)actionResult);
            }
        }
        if (!CoreUtils.isNullOrEmpty(piiTasksItems)) {
            for (i = 0; i < piiTasksItems.size(); ++i) {
                taskItem = piiTasksItems.get(i);
                actionResult = new RecognizePiiEntitiesActionResult();
                results = ((TasksStateTasksEntityRecognitionPiiTasksItem)taskItem).getResults();
                if (results != null) {
                    RecognizePiiEntitiesActionResultPropertiesHelper.setDocumentsResults((RecognizePiiEntitiesActionResult)actionResult, Utility.toRecognizePiiEntitiesResultCollection((PiiResult)results));
                }
                TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, ((TaskState)taskItem).getTaskName());
                TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, ((TaskState)taskItem).getLastUpdateDateTime());
                recognizePiiEntitiesActionResults.add((RecognizeEntitiesActionResult)actionResult);
            }
        }
        if (!CoreUtils.isNullOrEmpty(keyPhraseExtractionTasks)) {
            for (i = 0; i < keyPhraseExtractionTasks.size(); ++i) {
                taskItem = keyPhraseExtractionTasks.get(i);
                actionResult = new ExtractKeyPhrasesActionResult();
                results = ((TasksStateTasksKeyPhraseExtractionTasksItem)taskItem).getResults();
                if (results != null) {
                    ExtractKeyPhrasesActionResultPropertiesHelper.setDocumentsResults((ExtractKeyPhrasesActionResult)actionResult, Utility.toExtractKeyPhrasesResultCollection((KeyPhraseResult)results));
                }
                TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, ((TaskState)taskItem).getTaskName());
                TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, ((TaskState)taskItem).getLastUpdateDateTime());
                extractKeyPhrasesActionResults.add((RecognizeEntitiesActionResult)actionResult);
            }
        }
        if (!CoreUtils.isNullOrEmpty(linkedEntityRecognitionTasksItems)) {
            for (i = 0; i < linkedEntityRecognitionTasksItems.size(); ++i) {
                taskItem = linkedEntityRecognitionTasksItems.get(i);
                actionResult = new RecognizeLinkedEntitiesActionResult();
                results = ((TasksStateTasksEntityLinkingTasksItem)taskItem).getResults();
                if (results != null) {
                    RecognizeLinkedEntitiesActionResultPropertiesHelper.setDocumentsResults((RecognizeLinkedEntitiesActionResult)actionResult, Utility.toRecognizeLinkedEntitiesResultCollection((EntityLinkingResult)results));
                }
                TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, ((TaskState)taskItem).getTaskName());
                TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, ((TaskState)taskItem).getLastUpdateDateTime());
                recognizeLinkedEntitiesActionResults.add((RecognizeEntitiesActionResult)actionResult);
            }
        }
        if (!CoreUtils.isNullOrEmpty(sentimentAnalysisTasksItems)) {
            for (i = 0; i < sentimentAnalysisTasksItems.size(); ++i) {
                taskItem = sentimentAnalysisTasksItems.get(i);
                actionResult = new AnalyzeSentimentActionResult();
                results = ((TasksStateTasksSentimentAnalysisTasksItem)taskItem).getResults();
                if (results != null) {
                    AnalyzeSentimentActionResultPropertiesHelper.setDocumentsResults((AnalyzeSentimentActionResult)actionResult, Utility.toAnalyzeSentimentResultCollection((SentimentResponse)results));
                }
                TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, ((TaskState)taskItem).getTaskName());
                TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, ((TaskState)taskItem).getLastUpdateDateTime());
                analyzeSentimentActionResults.add((RecognizeEntitiesActionResult)actionResult);
            }
        }
        if (!CoreUtils.isNullOrEmpty(errors = analyzeJobState.getErrors())) {
            for (TextAnalyticsError error : errors) {
                TextAnalyticsActionResult actionResult2;
                if (error == null) continue;
                String[] targetPair = this.parseActionErrorTarget(error.getTarget(), error.getMessage());
                String taskName = targetPair[0];
                Integer taskIndex = Integer.valueOf(targetPair[1]);
                if (ENTITY_RECOGNITION_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)recognizeEntitiesActionResults.get(taskIndex);
                } else if (ENTITY_RECOGNITION_PII_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)recognizePiiEntitiesActionResults.get(taskIndex);
                } else if (KEY_PHRASE_EXTRACTION_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)extractKeyPhrasesActionResults.get(taskIndex);
                } else if (ENTITY_LINKING_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)recognizeLinkedEntitiesActionResults.get(taskIndex);
                } else if (SENTIMENT_ANALYSIS_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)analyzeSentimentActionResults.get(taskIndex);
                } else if (EXTRACTIVE_SUMMARIZATION_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)extractSummaryActionResults.get(taskIndex);
                } else if (CUSTOM_ENTITY_RECOGNITION_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)recognizeCustomEntitiesActionResults.get(taskIndex);
                } else if (CUSTOM_SINGLE_CLASSIFICATION_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)singleCategoryClassifyActionResults.get(taskIndex);
                } else if (CUSTOM_MULTI_CLASSIFICATION_TASKS.equals(taskName)) {
                    actionResult2 = (TextAnalyticsActionResult)multiCategoryClassifyActionResults.get(taskIndex);
                } else {
                    throw this.logger.logExceptionAsError(new RuntimeException("Invalid task name in target reference, " + taskName));
                }
                TextAnalyticsActionResultPropertiesHelper.setIsError(actionResult2, true);
                TextAnalyticsActionResultPropertiesHelper.setError(actionResult2, new TextAnalyticsError(TextAnalyticsErrorCode.fromString(error.getErrorCode() == null ? null : error.getErrorCode().toString()), error.getMessage(), null));
            }
        }
        AnalyzeActionsResult analyzeActionsResult = new AnalyzeActionsResult();
        AnalyzeActionsResultPropertiesHelper.setRecognizeEntitiesResults(analyzeActionsResult, (IterableStream<RecognizeEntitiesActionResult>)IterableStream.of(recognizeEntitiesActionResults));
        AnalyzeActionsResultPropertiesHelper.setRecognizePiiEntitiesResults(analyzeActionsResult, (IterableStream<RecognizePiiEntitiesActionResult>)IterableStream.of(recognizePiiEntitiesActionResults));
        AnalyzeActionsResultPropertiesHelper.setExtractKeyPhrasesResults(analyzeActionsResult, (IterableStream<ExtractKeyPhrasesActionResult>)IterableStream.of(extractKeyPhrasesActionResults));
        AnalyzeActionsResultPropertiesHelper.setRecognizeLinkedEntitiesResults(analyzeActionsResult, (IterableStream<RecognizeLinkedEntitiesActionResult>)IterableStream.of(recognizeLinkedEntitiesActionResults));
        AnalyzeActionsResultPropertiesHelper.setAnalyzeSentimentResults(analyzeActionsResult, (IterableStream<AnalyzeSentimentActionResult>)IterableStream.of(analyzeSentimentActionResults));
        AnalyzeActionsResultPropertiesHelper.setExtractSummaryResults(analyzeActionsResult, (IterableStream<ExtractSummaryActionResult>)IterableStream.of(extractSummaryActionResults));
        AnalyzeActionsResultPropertiesHelper.setRecognizeCustomEntitiesResults(analyzeActionsResult, (IterableStream<RecognizeCustomEntitiesActionResult>)IterableStream.of(recognizeCustomEntitiesActionResults));
        AnalyzeActionsResultPropertiesHelper.setClassifySingleCategoryResults(analyzeActionsResult, (IterableStream<SingleCategoryClassifyActionResult>)IterableStream.of(singleCategoryClassifyActionResults));
        AnalyzeActionsResultPropertiesHelper.setClassifyMultiCategoryResults(analyzeActionsResult, (IterableStream<MultiCategoryClassifyActionResult>)IterableStream.of(multiCategoryClassifyActionResults));
        return analyzeActionsResult;
    }

    private AnalyzeActionsResult toAnalyzeActionsResultLanguageApi(AnalyzeTextJobState analyzeJobState) {
        List<Error> errors;
        TasksStateTasks tasksStateTasks = analyzeJobState.getTasks();
        List<AnalyzeTextLROResult> tasksResults = tasksStateTasks.getItems();
        ArrayList<RecognizeEntitiesActionResult> recognizeEntitiesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> recognizePiiEntitiesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> extractKeyPhrasesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> recognizeLinkedEntitiesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> analyzeHealthcareEntitiesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> analyzeSentimentActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> extractSummaryActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> recognizeCustomEntitiesActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> singleCategoryClassifyActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        ArrayList<RecognizeEntitiesActionResult> multiCategoryClassifyActionResults = new ArrayList<RecognizeEntitiesActionResult>();
        if (!CoreUtils.isNullOrEmpty(tasksResults)) {
            for (int i = 0; i < tasksResults.size(); ++i) {
                Object results;
                TextAnalyticsActionResult actionResult;
                AnalyzeTextLROResult taskResult = tasksResults.get(i);
                if (taskResult instanceof EntityRecognitionLROResult) {
                    EntityRecognitionLROResult entityTaskResult = (EntityRecognitionLROResult)taskResult;
                    actionResult = new RecognizeEntitiesActionResult();
                    results = entityTaskResult.getResults();
                    if (results != null) {
                        RecognizeEntitiesActionResultPropertiesHelper.setDocumentsResults(actionResult, Utility.toRecognizeEntitiesResultCollectionResponse((EntitiesResult)results));
                    }
                    TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, entityTaskResult.getTaskName());
                    TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, entityTaskResult.getLastUpdateDateTime());
                    recognizeEntitiesActionResults.add((RecognizeEntitiesActionResult)actionResult);
                    continue;
                }
                if (taskResult instanceof CustomEntityRecognitionLROResult) {
                    CustomEntityRecognitionLROResult customEntityTaskResult = (CustomEntityRecognitionLROResult)taskResult;
                    actionResult = new RecognizeCustomEntitiesActionResult();
                    results = customEntityTaskResult.getResults();
                    if (results != null) {
                        RecognizeCustomEntitiesActionResultPropertiesHelper.setDocumentsResults((RecognizeCustomEntitiesActionResult)actionResult, Utility.toRecognizeCustomEntitiesResultCollection((CustomEntitiesResult)results));
                    }
                    TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, customEntityTaskResult.getTaskName());
                    TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, customEntityTaskResult.getLastUpdateDateTime());
                    recognizeCustomEntitiesActionResults.add((RecognizeEntitiesActionResult)actionResult);
                    continue;
                }
                if (taskResult instanceof CustomSingleLabelClassificationLROResult) {
                    CustomSingleLabelClassificationLROResult customSingleLabelClassificationResult = (CustomSingleLabelClassificationLROResult)taskResult;
                    actionResult = new SingleCategoryClassifyActionResult();
                    results = customSingleLabelClassificationResult.getResults();
                    if (results != null) {
                        SingleCategoryClassifyActionResultPropertiesHelper.setDocumentsResults((SingleCategoryClassifyActionResult)actionResult, Utility.toSingleCategoryClassifyResultCollection((CustomSingleLabelClassificationResult)results));
                    }
                    TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, customSingleLabelClassificationResult.getTaskName());
                    TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, customSingleLabelClassificationResult.getLastUpdateDateTime());
                    singleCategoryClassifyActionResults.add((RecognizeEntitiesActionResult)actionResult);
                    continue;
                }
                if (taskResult instanceof CustomMultiLabelClassificationLROResult) {
                    CustomMultiLabelClassificationLROResult customMultiLabelClassificationLROResult = (CustomMultiLabelClassificationLROResult)taskResult;
                    actionResult = new MultiCategoryClassifyActionResult();
                    results = customMultiLabelClassificationLROResult.getResults();
                    if (results != null) {
                        MultiCategoryClassifyActionResultPropertiesHelper.setDocumentsResults((MultiCategoryClassifyActionResult)actionResult, Utility.toMultiCategoryClassifyResultCollection((CustomMultiLabelClassificationResult)results));
                    }
                    TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, customMultiLabelClassificationLROResult.getTaskName());
                    TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, customMultiLabelClassificationLROResult.getLastUpdateDateTime());
                    multiCategoryClassifyActionResults.add((RecognizeEntitiesActionResult)actionResult);
                    continue;
                }
                if (taskResult instanceof EntityLinkingLROResult) {
                    EntityLinkingLROResult entityLinkingLROResult = (EntityLinkingLROResult)taskResult;
                    actionResult = new RecognizeLinkedEntitiesActionResult();
                    results = entityLinkingLROResult.getResults();
                    if (results != null) {
                        RecognizeLinkedEntitiesActionResultPropertiesHelper.setDocumentsResults((RecognizeLinkedEntitiesActionResult)actionResult, Utility.toRecognizeLinkedEntitiesResultCollection((EntityLinkingResult)results));
                    }
                    TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, entityLinkingLROResult.getTaskName());
                    TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, entityLinkingLROResult.getLastUpdateDateTime());
                    recognizeLinkedEntitiesActionResults.add((RecognizeEntitiesActionResult)actionResult);
                    continue;
                }
                if (taskResult instanceof PiiEntityRecognitionLROResult) {
                    PiiEntityRecognitionLROResult piiEntityRecognitionLROResult = (PiiEntityRecognitionLROResult)taskResult;
                    actionResult = new RecognizePiiEntitiesActionResult();
                    results = piiEntityRecognitionLROResult.getResults();
                    if (results != null) {
                        RecognizePiiEntitiesActionResultPropertiesHelper.setDocumentsResults((RecognizePiiEntitiesActionResult)actionResult, Utility.toRecognizePiiEntitiesResultCollection((PiiResult)results));
                    }
                    TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, piiEntityRecognitionLROResult.getTaskName());
                    TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, piiEntityRecognitionLROResult.getLastUpdateDateTime());
                    recognizePiiEntitiesActionResults.add((RecognizeEntitiesActionResult)actionResult);
                    continue;
                }
                if (taskResult instanceof ExtractiveSummarizationLROResult) {
                    ExtractiveSummarizationLROResult extractiveSummarizationLROResult = (ExtractiveSummarizationLROResult)taskResult;
                    actionResult = new ExtractSummaryActionResult();
                    results = extractiveSummarizationLROResult.getResults();
                    if (results != null) {
                        ExtractSummaryActionResultPropertiesHelper.setDocumentsResults((ExtractSummaryActionResult)actionResult, Utility.toExtractSummaryResultCollection((ExtractiveSummarizationResult)results));
                    }
                    TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, extractiveSummarizationLROResult.getTaskName());
                    TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, extractiveSummarizationLROResult.getLastUpdateDateTime());
                    extractSummaryActionResults.add((RecognizeEntitiesActionResult)actionResult);
                    continue;
                }
                if (taskResult instanceof HealthcareLROResult) {
                    HealthcareLROResult healthcareLROResult = (HealthcareLROResult)taskResult;
                    actionResult = new AnalyzeHealthcareEntitiesActionResult();
                    results = healthcareLROResult.getResults();
                    if (results != null) {
                        AnalyzeHealthcareEntitiesActionResultPropertiesHelper.setDocumentsResults((AnalyzeHealthcareEntitiesActionResult)actionResult, Utility.toAnalyzeHealthcareEntitiesResultCollection((HealthcareResult)results));
                    }
                    TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, healthcareLROResult.getTaskName());
                    TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, healthcareLROResult.getLastUpdateDateTime());
                    analyzeHealthcareEntitiesActionResults.add((RecognizeEntitiesActionResult)actionResult);
                    continue;
                }
                if (taskResult instanceof SentimentLROResult) {
                    SentimentLROResult sentimentLROResult = (SentimentLROResult)taskResult;
                    actionResult = new AnalyzeSentimentActionResult();
                    results = sentimentLROResult.getResults();
                    if (results != null) {
                        AnalyzeSentimentActionResultPropertiesHelper.setDocumentsResults((AnalyzeSentimentActionResult)actionResult, Utility.toAnalyzeSentimentResultCollection((SentimentResponse)results));
                    }
                    TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, sentimentLROResult.getTaskName());
                    TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, sentimentLROResult.getLastUpdateDateTime());
                    analyzeSentimentActionResults.add((RecognizeEntitiesActionResult)actionResult);
                    continue;
                }
                if (taskResult instanceof KeyPhraseExtractionLROResult) {
                    KeyPhraseExtractionLROResult keyPhraseExtractionLROResult = (KeyPhraseExtractionLROResult)taskResult;
                    actionResult = new ExtractKeyPhrasesActionResult();
                    results = keyPhraseExtractionLROResult.getResults();
                    if (results != null) {
                        ExtractKeyPhrasesActionResultPropertiesHelper.setDocumentsResults((ExtractKeyPhrasesActionResult)actionResult, Utility.toExtractKeyPhrasesResultCollection((KeyPhraseResult)results));
                    }
                    TextAnalyticsActionResultPropertiesHelper.setActionName(actionResult, keyPhraseExtractionLROResult.getTaskName());
                    TextAnalyticsActionResultPropertiesHelper.setCompletedAt(actionResult, keyPhraseExtractionLROResult.getLastUpdateDateTime());
                    extractKeyPhrasesActionResults.add((RecognizeEntitiesActionResult)actionResult);
                    continue;
                }
                throw this.logger.logExceptionAsError(new RuntimeException("Invalid Long running operation task result: " + taskResult.getClass()));
            }
        }
        if (!CoreUtils.isNullOrEmpty(errors = analyzeJobState.getErrors())) {
            for (Error error : errors) {
                TextAnalyticsActionResult actionResult;
                if (error == null) continue;
                String[] targetPair = this.parseActionErrorTarget(error.getTarget(), error.getMessage());
                String taskName = targetPair[0];
                Integer taskIndex = Integer.valueOf(targetPair[1]);
                if (ENTITY_RECOGNITION_TASKS.equals(taskName)) {
                    actionResult = (TextAnalyticsActionResult)recognizeEntitiesActionResults.get(taskIndex);
                } else if (ENTITY_RECOGNITION_PII_TASKS.equals(taskName)) {
                    actionResult = (TextAnalyticsActionResult)recognizePiiEntitiesActionResults.get(taskIndex);
                } else if (KEY_PHRASE_EXTRACTION_TASKS.equals(taskName)) {
                    actionResult = (TextAnalyticsActionResult)extractKeyPhrasesActionResults.get(taskIndex);
                } else if (ENTITY_LINKING_TASKS.equals(taskName)) {
                    actionResult = (TextAnalyticsActionResult)recognizeLinkedEntitiesActionResults.get(taskIndex);
                } else if (SENTIMENT_ANALYSIS_TASKS.equals(taskName)) {
                    actionResult = (TextAnalyticsActionResult)analyzeSentimentActionResults.get(taskIndex);
                } else if (EXTRACTIVE_SUMMARIZATION_TASKS.equals(taskName)) {
                    actionResult = (TextAnalyticsActionResult)extractSummaryActionResults.get(taskIndex);
                } else if (CUSTOM_ENTITY_RECOGNITION_TASKS.equals(taskName)) {
                    actionResult = (TextAnalyticsActionResult)recognizeCustomEntitiesActionResults.get(taskIndex);
                } else if (CUSTOM_SINGLE_CLASSIFICATION_TASKS.equals(taskName)) {
                    actionResult = (TextAnalyticsActionResult)singleCategoryClassifyActionResults.get(taskIndex);
                } else if (CUSTOM_MULTI_CLASSIFICATION_TASKS.equals(taskName)) {
                    actionResult = (TextAnalyticsActionResult)multiCategoryClassifyActionResults.get(taskIndex);
                } else {
                    throw this.logger.logExceptionAsError(new RuntimeException("Invalid task name in target reference, " + taskName));
                }
                TextAnalyticsActionResultPropertiesHelper.setIsError(actionResult, true);
                TextAnalyticsActionResultPropertiesHelper.setError(actionResult, new TextAnalyticsError(TextAnalyticsErrorCode.fromString(error.getCode() == null ? null : error.getCode().toString()), error.getMessage(), null));
            }
        }
        AnalyzeActionsResult analyzeActionsResult = new AnalyzeActionsResult();
        AnalyzeActionsResultPropertiesHelper.setRecognizeEntitiesResults(analyzeActionsResult, (IterableStream<RecognizeEntitiesActionResult>)IterableStream.of(recognizeEntitiesActionResults));
        AnalyzeActionsResultPropertiesHelper.setRecognizePiiEntitiesResults(analyzeActionsResult, (IterableStream<RecognizePiiEntitiesActionResult>)IterableStream.of(recognizePiiEntitiesActionResults));
        AnalyzeActionsResultPropertiesHelper.setAnalyzeHealthcareEntitiesResults(analyzeActionsResult, (IterableStream<AnalyzeHealthcareEntitiesActionResult>)IterableStream.of(analyzeHealthcareEntitiesActionResults));
        AnalyzeActionsResultPropertiesHelper.setExtractKeyPhrasesResults(analyzeActionsResult, (IterableStream<ExtractKeyPhrasesActionResult>)IterableStream.of(extractKeyPhrasesActionResults));
        AnalyzeActionsResultPropertiesHelper.setRecognizeLinkedEntitiesResults(analyzeActionsResult, (IterableStream<RecognizeLinkedEntitiesActionResult>)IterableStream.of(recognizeLinkedEntitiesActionResults));
        AnalyzeActionsResultPropertiesHelper.setAnalyzeSentimentResults(analyzeActionsResult, (IterableStream<AnalyzeSentimentActionResult>)IterableStream.of(analyzeSentimentActionResults));
        AnalyzeActionsResultPropertiesHelper.setExtractSummaryResults(analyzeActionsResult, (IterableStream<ExtractSummaryActionResult>)IterableStream.of(extractSummaryActionResults));
        AnalyzeActionsResultPropertiesHelper.setRecognizeCustomEntitiesResults(analyzeActionsResult, (IterableStream<RecognizeCustomEntitiesActionResult>)IterableStream.of(recognizeCustomEntitiesActionResults));
        AnalyzeActionsResultPropertiesHelper.setClassifySingleCategoryResults(analyzeActionsResult, (IterableStream<SingleCategoryClassifyActionResult>)IterableStream.of(singleCategoryClassifyActionResults));
        AnalyzeActionsResultPropertiesHelper.setClassifyMultiCategoryResults(analyzeActionsResult, (IterableStream<MultiCategoryClassifyActionResult>)IterableStream.of(multiCategoryClassifyActionResults));
        return analyzeActionsResult;
    }

    private Mono<PollResponse<AnalyzeActionsOperationDetail>> processAnalyzedModelResponse(Response<AnalyzeJobState> analyzeJobStateResponse, PollResponse<AnalyzeActionsOperationDetail> operationResultPollResponse) {
        LongRunningOperationStatus status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
        if (analyzeJobStateResponse.getValue() != null && ((AnalyzeJobState)analyzeJobStateResponse.getValue()).getStatus() != null) {
            switch (((AnalyzeJobState)analyzeJobStateResponse.getValue()).getStatus()) {
                case NOT_STARTED: 
                case RUNNING: {
                    status = LongRunningOperationStatus.IN_PROGRESS;
                    break;
                }
                case SUCCEEDED: {
                    status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                    break;
                }
                case CANCELLED: {
                    status = LongRunningOperationStatus.USER_CANCELLED;
                    break;
                }
                default: {
                    status = LongRunningOperationStatus.fromString((String)((AnalyzeJobState)analyzeJobStateResponse.getValue()).getStatus().toString(), (boolean)true);
                }
            }
        }
        AnalyzeActionsOperationDetailPropertiesHelper.setDisplayName((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeJobState)analyzeJobStateResponse.getValue()).getDisplayName());
        AnalyzeActionsOperationDetailPropertiesHelper.setCreatedAt((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeJobState)analyzeJobStateResponse.getValue()).getCreatedDateTime());
        AnalyzeActionsOperationDetailPropertiesHelper.setExpiresAt((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeJobState)analyzeJobStateResponse.getValue()).getExpirationDateTime());
        AnalyzeActionsOperationDetailPropertiesHelper.setLastModifiedAt((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeJobState)analyzeJobStateResponse.getValue()).getLastUpdateDateTime());
        TasksStateTasksOld tasksResult = ((AnalyzeJobState)analyzeJobStateResponse.getValue()).getTasks();
        AnalyzeActionsOperationDetailPropertiesHelper.setActionsFailed((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), tasksResult.getFailed());
        AnalyzeActionsOperationDetailPropertiesHelper.setActionsInProgress((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), tasksResult.getInProgress());
        AnalyzeActionsOperationDetailPropertiesHelper.setActionsSucceeded((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), tasksResult.getCompleted());
        AnalyzeActionsOperationDetailPropertiesHelper.setActionsInTotal((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), tasksResult.getTotal());
        return Mono.just((Object)new PollResponse(status, (Object)((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue())));
    }

    private Mono<PollResponse<AnalyzeActionsOperationDetail>> processAnalyzedModelResponseLanguageApi(Response<AnalyzeTextJobState> analyzeJobStateResponse, PollResponse<AnalyzeActionsOperationDetail> operationResultPollResponse) {
        LongRunningOperationStatus status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
        if (analyzeJobStateResponse.getValue() != null && ((AnalyzeTextJobState)analyzeJobStateResponse.getValue()).getStatus() != null) {
            switch (((AnalyzeTextJobState)analyzeJobStateResponse.getValue()).getStatus()) {
                case NOT_STARTED: 
                case RUNNING: {
                    status = LongRunningOperationStatus.IN_PROGRESS;
                    break;
                }
                case SUCCEEDED: {
                    status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                    break;
                }
                case CANCELLED: {
                    status = LongRunningOperationStatus.USER_CANCELLED;
                    break;
                }
                case PARTIALLY_SUCCEEDED: {
                    status = LongRunningOperationStatus.fromString((String)"partiallySucceeded", (boolean)true);
                    break;
                }
                default: {
                    status = LongRunningOperationStatus.fromString((String)((AnalyzeTextJobState)analyzeJobStateResponse.getValue()).getStatus().toString(), (boolean)true);
                }
            }
        }
        AnalyzeActionsOperationDetailPropertiesHelper.setDisplayName((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeJobStateResponse.getValue()).getDisplayName());
        AnalyzeActionsOperationDetailPropertiesHelper.setCreatedAt((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeJobStateResponse.getValue()).getCreatedDateTime());
        AnalyzeActionsOperationDetailPropertiesHelper.setExpiresAt((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeJobStateResponse.getValue()).getExpirationDateTime());
        AnalyzeActionsOperationDetailPropertiesHelper.setLastModifiedAt((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeJobStateResponse.getValue()).getLastUpdateDateTime());
        TasksStateTasks tasksResult = ((AnalyzeTextJobState)analyzeJobStateResponse.getValue()).getTasks();
        AnalyzeActionsOperationDetailPropertiesHelper.setActionsFailed((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), tasksResult.getFailed());
        AnalyzeActionsOperationDetailPropertiesHelper.setActionsInProgress((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), tasksResult.getInProgress());
        AnalyzeActionsOperationDetailPropertiesHelper.setActionsSucceeded((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), tasksResult.getCompleted());
        AnalyzeActionsOperationDetailPropertiesHelper.setActionsInTotal((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue(), tasksResult.getTotal());
        return Mono.just((Object)new PollResponse(status, (Object)((AnalyzeActionsOperationDetail)operationResultPollResponse.getValue())));
    }

    private Context getNotNullContext(Context context) {
        return context == null ? Context.NONE : context;
    }

    private AnalyzeActionsOptions getNotNullAnalyzeActionsOptions(AnalyzeActionsOptions options) {
        return options == null ? new AnalyzeActionsOptions() : options;
    }

    private String[] parseActionErrorTarget(String targetReference, String errorMessage) {
        if (CoreUtils.isNullOrEmpty((CharSequence)targetReference)) {
            if (CoreUtils.isNullOrEmpty((CharSequence)errorMessage)) {
                errorMessage = "Expected an error with a target field referencing an action but did not get one";
            }
            throw this.logger.logExceptionAsError(new RuntimeException(errorMessage));
        }
        Matcher matcher = PATTERN.matcher(targetReference);
        String[] taskNameIdPair = new String[2];
        while (matcher.find()) {
            taskNameIdPair[0] = matcher.group(1);
            taskNameIdPair[1] = matcher.group(2);
        }
        return taskNameIdPair;
    }
}

