/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.implementation.MicrosoftCognitiveLanguageServiceImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsClientImpl;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextSentimentAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageBatchInput;
import com.azure.ai.textanalytics.implementation.models.SentimentAnalysisTaskParameters;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.models.AnalyzeSentimentOptions;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.AnalyzeSentimentResultCollection;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import reactor.core.publisher.Mono;

class AnalyzeSentimentAsyncClient {
    private final ClientLogger logger = new ClientLogger(AnalyzeSentimentAsyncClient.class);
    private final TextAnalyticsClientImpl legacyService;
    private final MicrosoftCognitiveLanguageServiceImpl service;

    AnalyzeSentimentAsyncClient(TextAnalyticsClientImpl legacyService) {
        this.legacyService = legacyService;
        this.service = null;
    }

    AnalyzeSentimentAsyncClient(MicrosoftCognitiveLanguageServiceImpl service) {
        this.legacyService = null;
        this.service = service;
    }

    public Mono<Response<AnalyzeSentimentResultCollection>> analyzeSentimentBatch(Iterable<TextDocumentInput> documents, AnalyzeSentimentOptions options) {
        try {
            Utility.inputDocumentsValidation(documents);
            return FluxUtil.withContext(context -> this.getAnalyzedSentimentResponse(documents, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AnalyzeSentimentResultCollection>> analyzeSentimentBatchWithContext(Iterable<TextDocumentInput> documents, AnalyzeSentimentOptions options, Context context) {
        try {
            Utility.inputDocumentsValidation(documents);
            return this.getAnalyzedSentimentResponse(documents, options, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<AnalyzeSentimentResultCollection>> getAnalyzedSentimentResponse(Iterable<TextDocumentInput> documents, AnalyzeSentimentOptions options, Context context) {
        AnalyzeSentimentOptions analyzeSentimentOptions = options = options == null ? new AnalyzeSentimentOptions() : options;
        if (this.service != null) {
            return this.service.analyzeTextWithResponseAsync(new AnalyzeTextSentimentAnalysisInput().setParameters((SentimentAnalysisTaskParameters)new SentimentAnalysisTaskParameters().setStringIndexType(StringIndexType.UTF16CODE_UNIT).setOpinionMining(options.isIncludeOpinionMining()).setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled())).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))), options.isIncludeStatistics(), Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices")).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> this.logger.info("Analyzed sentiment for a batch of documents - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to analyze sentiment - {}", new Object[]{error})).map(Utility::toAnalyzeSentimentResultCollectionResponse2).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        return this.legacyService.sentimentWithResponseAsync(new MultiLanguageBatchInput().setDocuments(Utility.toMultiLanguageInput(documents)), options.getModelVersion(), options.isIncludeStatistics(), options.isServiceLogsDisabled(), options.isIncludeOpinionMining(), StringIndexType.UTF16CODE_UNIT, Utility.getNotNullContext(context).addData((Object)"az.namespace", (Object)"Microsoft.CognitiveServices")).doOnSubscribe(ignoredValue -> this.logger.info("A batch of documents with count - {}", new Object[]{Utility.getDocumentCount(documents)})).doOnSuccess(response -> this.logger.info("Analyzed sentiment for a batch of documents - {}", new Object[]{response})).doOnError(error -> this.logger.warning("Failed to analyze sentiment - {}", new Object[]{error})).map(Utility::toAnalyzeSentimentResultCollectionResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
    }
}

